/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFRequestforward;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFMessageVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFRequestforwardVer15
implements OFRequestforward {
    private static final Logger logger = LoggerFactory.getLogger(OFRequestforwardVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 16;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private final long xid;
    private final OFMessage request;
    static final Reader READER = new Reader();
    static final OFRequestforwardVer15Funnel FUNNEL = new OFRequestforwardVer15Funnel();
    static final Writer WRITER = new Writer();

    OFRequestforwardVer15(long xid, OFMessage request) {
        if (request == null) {
            throw new NullPointerException("OFRequestforwardVer15: property request cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.request = request;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.REQUESTFORWARD;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFMessage getRequest() {
        return this.request;
    }

    @Override
    public long getRole() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property role not supported in version 1.5");
    }

    @Override
    public byte[] getData() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property data not supported in version 1.5");
    }

    @Override
    public OFRequestforward.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFRequestforwardVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("request=").append(this.request);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRequestforwardVer15 other = (OFRequestforwardVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.request == null ? other.request != null : !this.request.equals(other.request));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFRequestforwardVer15 other = (OFRequestforwardVer15)obj;
        return !(this.request == null ? other.request != null : !this.request.equals(other.request));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.request == null ? 0 : this.request.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFRequestforwardVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFRequestforwardVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(32);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.request.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFRequestforwardVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFRequestforwardVer15Funnel
    implements Funnel<OFRequestforwardVer15> {
        private static final long serialVersionUID = 1L;

        OFRequestforwardVer15Funnel() {
        }

        public void funnel(OFRequestforwardVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)32);
            sink.putLong(message.xid);
            message.request.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFRequestforward> {
        Reader() {
        }

        @Override
        public OFRequestforward readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 32) {
                throw new OFParseError("Wrong type: Expected=OFType.REQUESTFORWARD(32), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            OFMessage request = OFMessageVer15.READER.readFrom(bb);
            OFRequestforwardVer15 requestforwardVer15 = new OFRequestforwardVer15(xid, request);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)requestforwardVer15);
            }
            return requestforwardVer15;
        }
    }

    static class Builder
    implements OFRequestforward.Builder {
        private boolean xidSet;
        private long xid;
        private boolean requestSet;
        private OFMessage request;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.REQUESTFORWARD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRequestforward.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMessage getRequest() {
            return this.request;
        }

        @Override
        public OFRequestforward.Builder setRequest(OFMessage request) {
            this.request = request;
            this.requestSet = true;
            return this;
        }

        @Override
        public long getRole() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFRequestforward.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public byte[] getData() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFRequestforward.Builder setData(byte[] data) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFRequestforward build() {
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.requestSet) {
                throw new IllegalStateException("Property request doesn't have default value -- must be set");
            }
            if (this.request == null) {
                throw new NullPointerException("Property request must not be null");
            }
            return new OFRequestforwardVer15(xid, this.request);
        }
    }

    static class BuilderWithParent
    implements OFRequestforward.Builder {
        final OFRequestforwardVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean requestSet;
        private OFMessage request;

        BuilderWithParent(OFRequestforwardVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.REQUESTFORWARD;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFRequestforward.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFMessage getRequest() {
            return this.request;
        }

        @Override
        public OFRequestforward.Builder setRequest(OFMessage request) {
            this.request = request;
            this.requestSet = true;
            return this;
        }

        @Override
        public long getRole() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public OFRequestforward.Builder setRole(long role) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property role not supported in version 1.5");
        }

        @Override
        public byte[] getData() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFRequestforward.Builder setData(byte[] data) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFRequestforward build() {
            OFMessage request;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFMessage oFMessage = request = this.requestSet ? this.request : this.parentMessage.request;
            if (request == null) {
                throw new NullPointerException("Property request must not be null");
            }
            return new OFRequestforwardVer15(xid, request);
        }
    }
}

