/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnMiscCapabilities;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnMiscCapabilitiesVer15
implements OFPortDescPropBsnMiscCapabilities {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnMiscCapabilitiesVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private static final U64 DEFAULT_CURRENT = U64.ZERO;
    private static final U64 DEFAULT_AVAILABLE = U64.ZERO;
    private static final U64 DEFAULT_SUPPORTED = U64.ZERO;
    private final U64 current;
    private final U64 available;
    private final U64 supported;
    static final OFPortDescPropBsnMiscCapabilitiesVer15 DEFAULT = new OFPortDescPropBsnMiscCapabilitiesVer15(DEFAULT_CURRENT, DEFAULT_AVAILABLE, DEFAULT_SUPPORTED);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnMiscCapabilitiesVer15Funnel FUNNEL = new OFPortDescPropBsnMiscCapabilitiesVer15Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnMiscCapabilitiesVer15(U64 current, U64 available, U64 supported) {
        if (current == null) {
            throw new NullPointerException("OFPortDescPropBsnMiscCapabilitiesVer15: property current cannot be null");
        }
        if (available == null) {
            throw new NullPointerException("OFPortDescPropBsnMiscCapabilitiesVer15: property available cannot be null");
        }
        if (supported == null) {
            throw new NullPointerException("OFPortDescPropBsnMiscCapabilitiesVer15: property supported cannot be null");
        }
        this.current = current;
        this.available = available;
        this.supported = supported;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 5L;
    }

    @Override
    public U64 getCurrent() {
        return this.current;
    }

    @Override
    public U64 getAvailable() {
        return this.available;
    }

    @Override
    public U64 getSupported() {
        return this.supported;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFPortDescPropBsnMiscCapabilities.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnMiscCapabilitiesVer15(");
        b.append("current=").append(this.current);
        b.append(", ");
        b.append("available=").append(this.available);
        b.append(", ");
        b.append("supported=").append(this.supported);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnMiscCapabilitiesVer15 other = (OFPortDescPropBsnMiscCapabilitiesVer15)obj;
        if (this.current == null ? other.current != null : !this.current.equals(other.current)) {
            return false;
        }
        if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
            return false;
        }
        return !(this.supported == null ? other.supported != null : !this.supported.equals(other.supported));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.current == null ? 0 : this.current.hashCode());
        result = 31 * result + (this.available == null ? 0 : this.available.hashCode());
        result = 31 * result + (this.supported == null ? 0 : this.supported.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnMiscCapabilitiesVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnMiscCapabilitiesVer15 message) {
            bb.writeShort(-1);
            bb.writeShort(36);
            bb.writeInt(6035143);
            bb.writeInt(5);
            bb.writeLong(message.current.getValue());
            bb.writeLong(message.available.getValue());
            bb.writeLong(message.supported.getValue());
        }
    }

    static class OFPortDescPropBsnMiscCapabilitiesVer15Funnel
    implements Funnel<OFPortDescPropBsnMiscCapabilitiesVer15> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnMiscCapabilitiesVer15Funnel() {
        }

        public void funnel(OFPortDescPropBsnMiscCapabilitiesVer15 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)36);
            sink.putInt(6035143);
            sink.putInt(5);
            message.current.putTo(sink);
            message.available.putTo(sink);
            message.supported.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnMiscCapabilities> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 36) {
                throw new OFParseError("Wrong length: Expected=36(36), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 5) {
                throw new OFParseError("Wrong expType: Expected=0x5L(0x5L), got=" + expType);
            }
            U64 current = U64.ofRaw(bb.readLong());
            U64 available = U64.ofRaw(bb.readLong());
            U64 supported = U64.ofRaw(bb.readLong());
            OFPortDescPropBsnMiscCapabilitiesVer15 portDescPropBsnMiscCapabilitiesVer15 = new OFPortDescPropBsnMiscCapabilitiesVer15(current, available, supported);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnMiscCapabilitiesVer15);
            }
            return portDescPropBsnMiscCapabilitiesVer15;
        }
    }

    static class Builder
    implements OFPortDescPropBsnMiscCapabilities.Builder {
        private boolean currentSet;
        private U64 current;
        private boolean availableSet;
        private U64 available;
        private boolean supportedSet;
        private U64 supported;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 5L;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getCurrent() {
            return this.current;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setCurrent(U64 current) {
            this.current = current;
            this.currentSet = true;
            return this;
        }

        @Override
        public U64 getAvailable() {
            return this.available;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setAvailable(U64 available) {
            this.available = available;
            this.availableSet = true;
            return this;
        }

        @Override
        public U64 getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setSupported(U64 supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities build() {
            U64 supported;
            U64 available;
            U64 current;
            U64 u64 = current = this.currentSet ? this.current : DEFAULT_CURRENT;
            if (current == null) {
                throw new NullPointerException("Property current must not be null");
            }
            U64 u642 = available = this.availableSet ? this.available : DEFAULT_AVAILABLE;
            if (available == null) {
                throw new NullPointerException("Property available must not be null");
            }
            U64 u643 = supported = this.supportedSet ? this.supported : DEFAULT_SUPPORTED;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            return new OFPortDescPropBsnMiscCapabilitiesVer15(current, available, supported);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnMiscCapabilities.Builder {
        final OFPortDescPropBsnMiscCapabilitiesVer15 parentMessage;
        private boolean currentSet;
        private U64 current;
        private boolean availableSet;
        private U64 available;
        private boolean supportedSet;
        private U64 supported;

        BuilderWithParent(OFPortDescPropBsnMiscCapabilitiesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 5L;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getCurrent() {
            return this.current;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setCurrent(U64 current) {
            this.current = current;
            this.currentSet = true;
            return this;
        }

        @Override
        public U64 getAvailable() {
            return this.available;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setAvailable(U64 available) {
            this.available = available;
            this.availableSet = true;
            return this;
        }

        @Override
        public U64 getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities.Builder setSupported(U64 supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFPortDescPropBsnMiscCapabilities build() {
            U64 supported;
            U64 available;
            U64 current;
            U64 u64 = current = this.currentSet ? this.current : this.parentMessage.current;
            if (current == null) {
                throw new NullPointerException("Property current must not be null");
            }
            U64 u642 = available = this.availableSet ? this.available : this.parentMessage.available;
            if (available == null) {
                throw new NullPointerException("Property available must not be null");
            }
            U64 u643 = supported = this.supportedSet ? this.supported : this.parentMessage.supported;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            return new OFPortDescPropBsnMiscCapabilitiesVer15(current, available, supported);
        }
    }
}

