/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.oxs.OFOxs;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsByteCountVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsDurationVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsFlowCountVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsIdleTimeVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFOxsPacketCountVer15;

abstract class OFOxsVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    public static final Reader READER = new Reader();

    OFOxsVer15() {
    }

    static class Reader
    implements OFMessageReader<OFOxs<?>> {
        Reader() {
        }

        @Override
        public OFOxs<?> readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 4) {
                return null;
            }
            int start = bb.readerIndex();
            int typeLen = bb.readInt();
            bb.readerIndex(start);
            switch (typeLen) {
                case -2147350520: {
                    return OFOxsByteCountVer15.READER.readFrom(bb);
                }
                case -2147352568: {
                    return OFOxsDurationVer15.READER.readFrom(bb);
                }
                case -2147351548: {
                    return OFOxsFlowCountVer15.READER.readFrom(bb);
                }
                case -2147352056: {
                    return OFOxsIdleTimeVer15.READER.readFrom(bb);
                }
                case -2147351032: {
                    return OFOxsPacketCountVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator typeLen of class OFOxsVer15: " + typeLen);
        }
    }
}

