/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmUdpSrc;
import org.projectfloodlight.openflow.types.TransportPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmUdpSrcVer15
implements OFOxmUdpSrc {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmUdpSrcVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final TransportPort DEFAULT_VALUE = TransportPort.NONE;
    private final TransportPort value;
    static final OFOxmUdpSrcVer15 DEFAULT = new OFOxmUdpSrcVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmUdpSrcVer15Funnel FUNNEL = new OFOxmUdpSrcVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmUdpSrcVer15(TransportPort value) {
        if (value == null) {
            throw new NullPointerException("OFOxmUdpSrcVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147491330L;
    }

    @Override
    public TransportPort getValue() {
        return this.value;
    }

    @Override
    public MatchField<TransportPort> getMatchField() {
        return MatchField.UDP_SRC;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<TransportPort> getCanonical() {
        return this;
    }

    @Override
    public TransportPort getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmUdpSrc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmUdpSrcVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmUdpSrcVer15 other = (OFOxmUdpSrcVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmUdpSrcVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmUdpSrcVer15 message) {
            bb.writeInt(-2147475966);
            message.value.write2Bytes(bb);
        }
    }

    static class OFOxmUdpSrcVer15Funnel
    implements Funnel<OFOxmUdpSrcVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmUdpSrcVer15Funnel() {
        }

        public void funnel(OFOxmUdpSrcVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147475966);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmUdpSrc> {
        Reader() {
        }

        @Override
        public OFOxmUdpSrc readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147475966) {
                throw new OFParseError("Wrong typeLen: Expected=0x80001e02L(0x80001e02L), got=" + typeLen);
            }
            TransportPort value = TransportPort.read2Bytes(bb);
            OFOxmUdpSrcVer15 oxmUdpSrcVer15 = new OFOxmUdpSrcVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmUdpSrcVer15);
            }
            return oxmUdpSrcVer15;
        }
    }

    static class Builder
    implements OFOxmUdpSrc.Builder {
        private boolean valueSet;
        private TransportPort value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147491330L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmUdpSrc.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.UDP_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmUdpSrc build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmUdpSrcVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmUdpSrc.Builder {
        final OFOxmUdpSrcVer15 parentMessage;
        private boolean valueSet;
        private TransportPort value;

        BuilderWithParent(OFOxmUdpSrcVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147491330L;
        }

        @Override
        public TransportPort getValue() {
            return this.value;
        }

        @Override
        public OFOxmUdpSrc.Builder setValue(TransportPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<TransportPort> getMatchField() {
            return MatchField.UDP_SRC;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<TransportPort> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public TransportPort getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmUdpSrc build() {
            TransportPort value;
            TransportPort transportPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmUdpSrcVer15(value);
        }
    }
}

