/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmConnTrackingLabelMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmConnTrackingLabelVer15;
import org.projectfloodlight.openflow.types.U128;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmConnTrackingLabelMaskedVer15
implements OFOxmConnTrackingLabelMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmConnTrackingLabelMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 36;
    private static final U128 DEFAULT_VALUE = U128.ZERO;
    private static final U128 DEFAULT_VALUE_MASK = U128.ZERO;
    private final U128 value;
    private final U128 mask;
    static final OFOxmConnTrackingLabelMaskedVer15 DEFAULT = new OFOxmConnTrackingLabelMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmConnTrackingLabelMaskedVer15Funnel FUNNEL = new OFOxmConnTrackingLabelMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmConnTrackingLabelMaskedVer15(U128 value, U128 mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmConnTrackingLabelMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmConnTrackingLabelMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 121120L;
    }

    @Override
    public U128 getValue() {
        return this.value;
    }

    @Override
    public U128 getMask() {
        return this.mask;
    }

    @Override
    public MatchField<U128> getMatchField() {
        return MatchField.CONN_TRACKING_LABEL;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<U128> getCanonical() {
        if (U128.NO_MASK.equals(this.mask)) {
            return new OFOxmConnTrackingLabelVer15(this.value);
        }
        if (U128.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmConnTrackingLabelMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmConnTrackingLabelMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmConnTrackingLabelMaskedVer15 other = (OFOxmConnTrackingLabelMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmConnTrackingLabelMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmConnTrackingLabelMaskedVer15 message) {
            bb.writeInt(121120);
            message.value.write16Bytes(bb);
            message.mask.write16Bytes(bb);
        }
    }

    static class OFOxmConnTrackingLabelMaskedVer15Funnel
    implements Funnel<OFOxmConnTrackingLabelMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmConnTrackingLabelMaskedVer15Funnel() {
        }

        public void funnel(OFOxmConnTrackingLabelMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(121120);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmConnTrackingLabelMasked> {
        Reader() {
        }

        @Override
        public OFOxmConnTrackingLabelMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 121120) {
                throw new OFParseError("Wrong typeLen: Expected=0x1d920L(0x1d920L), got=" + typeLen);
            }
            U128 value = U128.read16Bytes(bb);
            U128 mask = U128.read16Bytes(bb);
            OFOxmConnTrackingLabelMaskedVer15 oxmConnTrackingLabelMaskedVer15 = new OFOxmConnTrackingLabelMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmConnTrackingLabelMaskedVer15);
            }
            return oxmConnTrackingLabelMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmConnTrackingLabelMasked.Builder {
        private boolean valueSet;
        private U128 value;
        private boolean maskSet;
        private U128 mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 121120L;
        }

        @Override
        public U128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingLabelMasked.Builder setValue(U128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U128 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingLabelMasked.Builder setMask(U128 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U128> getMatchField() {
            return MatchField.CONN_TRACKING_LABEL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingLabelMasked build() {
            U128 mask;
            U128 value;
            U128 u128 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U128 u1282 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingLabelMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmConnTrackingLabelMasked.Builder {
        final OFOxmConnTrackingLabelMaskedVer15 parentMessage;
        private boolean valueSet;
        private U128 value;
        private boolean maskSet;
        private U128 mask;

        BuilderWithParent(OFOxmConnTrackingLabelMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 121120L;
        }

        @Override
        public U128 getValue() {
            return this.value;
        }

        @Override
        public OFOxmConnTrackingLabelMasked.Builder setValue(U128 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public U128 getMask() {
            return this.mask;
        }

        @Override
        public OFOxmConnTrackingLabelMasked.Builder setMask(U128 mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<U128> getMatchField() {
            return MatchField.CONN_TRACKING_LABEL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<U128> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmConnTrackingLabelMasked build() {
            U128 mask;
            U128 value;
            U128 u128 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            U128 u1282 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmConnTrackingLabelMaskedVer15(value, mask);
        }
    }
}

