/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnIngressPortGroupIdMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmBsnIngressPortGroupIdVer15;
import org.projectfloodlight.openflow.types.ClassId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnIngressPortGroupIdMaskedVer15
implements OFOxmBsnIngressPortGroupIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnIngressPortGroupIdMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final ClassId DEFAULT_VALUE = ClassId.NONE;
    private static final ClassId DEFAULT_VALUE_MASK = ClassId.NONE;
    private final ClassId value;
    private final ClassId mask;
    static final OFOxmBsnIngressPortGroupIdMaskedVer15 DEFAULT = new OFOxmBsnIngressPortGroupIdMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnIngressPortGroupIdMaskedVer15Funnel FUNNEL = new OFOxmBsnIngressPortGroupIdMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnIngressPortGroupIdMaskedVer15(ClassId value, ClassId mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnIngressPortGroupIdMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnIngressPortGroupIdMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 207112L;
    }

    @Override
    public ClassId getValue() {
        return this.value;
    }

    @Override
    public ClassId getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ClassId> getMatchField() {
        return MatchField.BSN_INGRESS_PORT_GROUP_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ClassId> getCanonical() {
        if (ClassId.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnIngressPortGroupIdVer15(this.value);
        }
        if (ClassId.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnIngressPortGroupIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnIngressPortGroupIdMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnIngressPortGroupIdMaskedVer15 other = (OFOxmBsnIngressPortGroupIdMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnIngressPortGroupIdMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnIngressPortGroupIdMaskedVer15 message) {
            bb.writeInt(207112);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnIngressPortGroupIdMaskedVer15Funnel
    implements Funnel<OFOxmBsnIngressPortGroupIdMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnIngressPortGroupIdMaskedVer15Funnel() {
        }

        public void funnel(OFOxmBsnIngressPortGroupIdMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(207112);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnIngressPortGroupIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 207112) {
                throw new OFParseError("Wrong typeLen: Expected=0x32908L(0x32908L), got=" + typeLen);
            }
            ClassId value = ClassId.read4Bytes(bb);
            ClassId mask = ClassId.read4Bytes(bb);
            OFOxmBsnIngressPortGroupIdMaskedVer15 oxmBsnIngressPortGroupIdMaskedVer15 = new OFOxmBsnIngressPortGroupIdMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnIngressPortGroupIdMaskedVer15);
            }
            return oxmBsnIngressPortGroupIdMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmBsnIngressPortGroupIdMasked.Builder {
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 207112L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_INGRESS_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnIngressPortGroupIdMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnIngressPortGroupIdMasked.Builder {
        final OFOxmBsnIngressPortGroupIdMaskedVer15 parentMessage;
        private boolean valueSet;
        private ClassId value;
        private boolean maskSet;
        private ClassId mask;

        BuilderWithParent(OFOxmBsnIngressPortGroupIdMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 207112L;
        }

        @Override
        public ClassId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked.Builder setValue(ClassId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ClassId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked.Builder setMask(ClassId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ClassId> getMatchField() {
            return MatchField.BSN_INGRESS_PORT_GROUP_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ClassId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnIngressPortGroupIdMasked build() {
            ClassId mask;
            ClassId value;
            ClassId classId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ClassId classId2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnIngressPortGroupIdMaskedVer15(value, mask);
        }
    }
}

