/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.meterband.OFMeterBandDrop;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterBandDropVer15
implements OFMeterBandDrop {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterBandDropVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    private static final long DEFAULT_RATE = 0L;
    private static final long DEFAULT_BURST_SIZE = 0L;
    private final long rate;
    private final long burstSize;
    static final OFMeterBandDropVer15 DEFAULT = new OFMeterBandDropVer15(0L, 0L);
    static final Reader READER = new Reader();
    static final OFMeterBandDropVer15Funnel FUNNEL = new OFMeterBandDropVer15Funnel();
    static final Writer WRITER = new Writer();

    OFMeterBandDropVer15(long rate, long burstSize) {
        this.rate = U32.normalize(rate);
        this.burstSize = U32.normalize(burstSize);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public long getRate() {
        return this.rate;
    }

    @Override
    public long getBurstSize() {
        return this.burstSize;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFMeterBandDrop.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterBandDropVer15(");
        b.append("rate=").append(this.rate);
        b.append(", ");
        b.append("burstSize=").append(this.burstSize);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterBandDropVer15 other = (OFMeterBandDropVer15)obj;
        if (this.rate != other.rate) {
            return false;
        }
        return this.burstSize == other.burstSize;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.rate ^ this.rate >>> 32);
        result = 31 * (int)(this.burstSize ^ this.burstSize >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterBandDropVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterBandDropVer15 message) {
            bb.writeShort(1);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.rate));
            bb.writeInt(U32.t(message.burstSize));
            bb.writeZero(4);
        }
    }

    static class OFMeterBandDropVer15Funnel
    implements Funnel<OFMeterBandDropVer15> {
        private static final long serialVersionUID = 1L;

        OFMeterBandDropVer15Funnel() {
        }

        public void funnel(OFMeterBandDropVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)16);
            sink.putLong(message.rate);
            sink.putLong(message.burstSize);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterBandDrop> {
        Reader() {
        }

        @Override
        public OFMeterBandDrop readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long rate = U32.f(bb.readInt());
            long burstSize = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFMeterBandDropVer15 meterBandDropVer15 = new OFMeterBandDropVer15(rate, burstSize);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterBandDropVer15);
            }
            return meterBandDropVer15;
        }
    }

    static class Builder
    implements OFMeterBandDrop.Builder {
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandDrop.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandDrop.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterBandDrop build() {
            long rate = this.rateSet ? this.rate : 0L;
            long burstSize = this.burstSizeSet ? this.burstSize : 0L;
            return new OFMeterBandDropVer15(rate, burstSize);
        }
    }

    static class BuilderWithParent
    implements OFMeterBandDrop.Builder {
        final OFMeterBandDropVer15 parentMessage;
        private boolean rateSet;
        private long rate;
        private boolean burstSizeSet;
        private long burstSize;

        BuilderWithParent(OFMeterBandDropVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getRate() {
            return this.rate;
        }

        @Override
        public OFMeterBandDrop.Builder setRate(long rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public long getBurstSize() {
            return this.burstSize;
        }

        @Override
        public OFMeterBandDrop.Builder setBurstSize(long burstSize) {
            this.burstSize = burstSize;
            this.burstSizeSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterBandDrop build() {
            long rate = this.rateSet ? this.rate : this.parentMessage.rate;
            long burstSize = this.burstSizeSet ? this.burstSize : this.parentMessage.burstSize;
            return new OFMeterBandDropVer15(rate, burstSize);
        }
    }
}

