/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorMsg;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncConfigFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBadActionErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBadInstructionErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBadMatchErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBadPropertyErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBadRequestErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFExperimenterErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowMonitorFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFGroupModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFHelloFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMeterModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPortModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFQueueOpFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFRoleRequestFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFSwitchConfigFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableFeaturesFailedErrorMsgVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFTableModFailedErrorMsgVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFErrorMsgVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 10;
    public static final Reader READER = new Reader();

    OFErrorMsgVer15() {
    }

    static class Reader
    implements OFMessageReader<OFErrorMsg> {
        Reader() {
        }

        @Override
        public OFErrorMsg readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 10) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 10) {
                throw new OFParseError("Wrong length: Expected to be >= 10, was: " + length);
            }
            U32.f(bb.readInt());
            short errType = bb.readShort();
            bb.readerIndex(start);
            switch (errType) {
                case 2: {
                    return OFBadActionErrorMsgVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFBadRequestErrorMsgVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFFlowModFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFPortModFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFQueueOpFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFBadInstructionErrorMsgVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFBadMatchErrorMsgVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupModFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFSwitchConfigFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFTableModFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterErrorMsgVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFRoleRequestFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFMeterModFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 13: {
                    return OFTableFeaturesFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFAsyncConfigFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFBadPropertyErrorMsgVer15.READER.readFrom(bb);
                }
                case 17: {
                    return OFBundleFailedErrorMsgVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFFlowMonitorFailedErrorMsgVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator errType of class OFErrorMsgVer15: " + errType);
        }
    }
}

