/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleAddMsg;
import org.projectfloodlight.openflow.protocol.OFBundleFlags;
import org.projectfloodlight.openflow.protocol.OFBundleProp;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFlagsSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundlePropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFMessageVer15;
import org.projectfloodlight.openflow.types.BundleId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleAddMsgVer15
implements OFBundleAddMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleAddMsgVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 23;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFBundleFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final List<OFBundleProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final BundleId bundleId;
    private final Set<OFBundleFlags> flags;
    private final OFMessage message;
    private final List<OFBundleProp> properties;
    static final Reader READER = new Reader();
    static final OFBundleAddMsgVer15Funnel FUNNEL = new OFBundleAddMsgVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundleAddMsgVer15(long xid, BundleId bundleId, Set<OFBundleFlags> flags, OFMessage message, List<OFBundleProp> properties) {
        if (bundleId == null) {
            throw new NullPointerException("OFBundleAddMsgVer15: property bundleId cannot be null");
        }
        if (flags == null) {
            throw new NullPointerException("OFBundleAddMsgVer15: property flags cannot be null");
        }
        if (message == null) {
            throw new NullPointerException("OFBundleAddMsgVer15: property message cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBundleAddMsgVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.bundleId = bundleId;
        this.flags = flags;
        this.message = message;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.BUNDLE_ADD_MESSAGE;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public BundleId getBundleId() {
        return this.bundleId;
    }

    @Override
    public Set<OFBundleFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFMessage getMessage() {
        return this.message;
    }

    @Override
    public List<OFBundleProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFMessage getData() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property data not supported in version 1.5");
    }

    @Override
    public OFBundleAddMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleAddMsgVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("bundleId=").append(this.bundleId);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("message=").append(this.message);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleAddMsgVer15 other = (OFBundleAddMsgVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleAddMsgVer15 other = (OFBundleAddMsgVer15)obj;
        if (this.bundleId == null ? other.bundleId != null : !this.bundleId.equals(other.bundleId)) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bundleId == null ? 0 : this.bundleId.hashCode());
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleAddMsgVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleAddMsgVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(34);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            message.bundleId.write4Bytes(bb);
            bb.writeZero(1);
            OFBundleFlagsSerializerVer15.writeTo(bb, message.flags);
            message.message.writeTo(bb);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBundleAddMsgVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleAddMsgVer15Funnel
    implements Funnel<OFBundleAddMsgVer15> {
        private static final long serialVersionUID = 1L;

        OFBundleAddMsgVer15Funnel() {
        }

        public void funnel(OFBundleAddMsgVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)34);
            sink.putLong(message.xid);
            message.bundleId.putTo(sink);
            OFBundleFlagsSerializerVer15.putTo(message.flags, sink);
            message.message.putTo(sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleAddMsg> {
        Reader() {
        }

        @Override
        public OFBundleAddMsg readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 34) {
                throw new OFParseError("Wrong type: Expected=OFType.BUNDLE_ADD_MESSAGE(34), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 23) {
                throw new OFParseError("Wrong length: Expected to be >= 23, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            BundleId bundleId = BundleId.read4Bytes(bb);
            bb.skipBytes(1);
            Set<OFBundleFlags> flags = OFBundleFlagsSerializerVer15.readFrom(bb);
            OFMessage message = OFMessageVer15.READER.readFrom(bb);
            List<OFBundleProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBundlePropVer15.READER);
            OFBundleAddMsgVer15 bundleAddMsgVer15 = new OFBundleAddMsgVer15(xid, bundleId, flags, message, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleAddMsgVer15);
            }
            return bundleAddMsgVer15;
        }
    }

    static class Builder
    implements OFBundleAddMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean messageSet;
        private OFMessage message;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_ADD_MESSAGE;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleAddMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleAddMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleAddMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMessage getMessage() {
            return this.message;
        }

        @Override
        public OFBundleAddMsg.Builder setMessage(OFMessage message) {
            this.message = message;
            this.messageSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleAddMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFMessage getData() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFBundleAddMsg.Builder setData(OFMessage data) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFBundleAddMsg build() {
            List<OFBundleProp> properties;
            Set<OFBundleFlags> flags;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.bundleIdSet) {
                throw new IllegalStateException("Property bundleId doesn't have default value -- must be set");
            }
            if (this.bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            Set<OFBundleFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.messageSet) {
                throw new IllegalStateException("Property message doesn't have default value -- must be set");
            }
            if (this.message == null) {
                throw new NullPointerException("Property message must not be null");
            }
            List<OFBundleProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleAddMsgVer15(xid, this.bundleId, flags, this.message, properties);
        }
    }

    static class BuilderWithParent
    implements OFBundleAddMsg.Builder {
        final OFBundleAddMsgVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean bundleIdSet;
        private BundleId bundleId;
        private boolean flagsSet;
        private Set<OFBundleFlags> flags;
        private boolean messageSet;
        private OFMessage message;
        private boolean propertiesSet;
        private List<OFBundleProp> properties;

        BuilderWithParent(OFBundleAddMsgVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.BUNDLE_ADD_MESSAGE;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleAddMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public BundleId getBundleId() {
            return this.bundleId;
        }

        @Override
        public OFBundleAddMsg.Builder setBundleId(BundleId bundleId) {
            this.bundleId = bundleId;
            this.bundleIdSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleAddMsg.Builder setFlags(Set<OFBundleFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFMessage getMessage() {
            return this.message;
        }

        @Override
        public OFBundleAddMsg.Builder setMessage(OFMessage message) {
            this.message = message;
            this.messageSet = true;
            return this;
        }

        @Override
        public List<OFBundleProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleAddMsg.Builder setProperties(List<OFBundleProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFMessage getData() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFBundleAddMsg.Builder setData(OFMessage data) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property data not supported in version 1.5");
        }

        @Override
        public OFBundleAddMsg build() {
            List properties;
            OFMessage message;
            Set flags;
            BundleId bundleId;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            BundleId bundleId2 = bundleId = this.bundleIdSet ? this.bundleId : this.parentMessage.bundleId;
            if (bundleId == null) {
                throw new NullPointerException("Property bundleId must not be null");
            }
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFMessage oFMessage = message = this.messageSet ? this.message : this.parentMessage.message;
            if (message == null) {
                throw new NullPointerException("Property message must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleAddMsgVer15(xid, bundleId, flags, message, properties);
        }
    }
}

