/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnRoutingParam;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvRoutingParam;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnRoutingParamSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvRoutingParamVer15
implements OFBsnTlvRoutingParam {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvRoutingParamVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private final OFBsnRoutingParam value;
    static final Reader READER = new Reader();
    static final OFBsnTlvRoutingParamVer15Funnel FUNNEL = new OFBsnTlvRoutingParamVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvRoutingParamVer15(OFBsnRoutingParam value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvRoutingParamVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 161;
    }

    @Override
    public OFBsnRoutingParam getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvRoutingParam.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvRoutingParamVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvRoutingParamVer15 other = (OFBsnTlvRoutingParamVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvRoutingParamVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvRoutingParamVer15 message) {
            bb.writeShort(161);
            bb.writeShort(6);
            OFBsnRoutingParamSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvRoutingParamVer15Funnel
    implements Funnel<OFBsnTlvRoutingParamVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvRoutingParamVer15Funnel() {
        }

        public void funnel(OFBsnTlvRoutingParamVer15 message, PrimitiveSink sink) {
            sink.putShort((short)161);
            sink.putShort((short)6);
            OFBsnRoutingParamSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvRoutingParam> {
        Reader() {
        }

        @Override
        public OFBsnTlvRoutingParam readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 161) {
                throw new OFParseError("Wrong type: Expected=0xa1(0xa1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnRoutingParam value = OFBsnRoutingParamSerializerVer15.readFrom(bb);
            OFBsnTlvRoutingParamVer15 bsnTlvRoutingParamVer15 = new OFBsnTlvRoutingParamVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvRoutingParamVer15);
            }
            return bsnTlvRoutingParamVer15;
        }
    }

    static class Builder
    implements OFBsnTlvRoutingParam.Builder {
        private boolean valueSet;
        private OFBsnRoutingParam value;

        Builder() {
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvRoutingParam.Builder {
        final OFBsnTlvRoutingParamVer15 parentMessage;
        private boolean valueSet;
        private OFBsnRoutingParam value;

        BuilderWithParent(OFBsnTlvRoutingParamVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 161;
        }

        @Override
        public OFBsnRoutingParam getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvRoutingParam.Builder setValue(OFBsnRoutingParam value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvRoutingParam build() {
            OFBsnRoutingParam value;
            OFBsnRoutingParam oFBsnRoutingParam = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvRoutingParamVer15(value);
        }
    }
}

