/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvExternalNetmask;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvExternalNetmaskVer15
implements OFBsnTlvExternalNetmask {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvExternalNetmaskVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvExternalNetmaskVer15 DEFAULT = new OFBsnTlvExternalNetmaskVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvExternalNetmaskVer15Funnel FUNNEL = new OFBsnTlvExternalNetmaskVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvExternalNetmaskVer15(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvExternalNetmaskVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 25;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvExternalNetmask.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvExternalNetmaskVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvExternalNetmaskVer15 other = (OFBsnTlvExternalNetmaskVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvExternalNetmaskVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvExternalNetmaskVer15 message) {
            bb.writeShort(25);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvExternalNetmaskVer15Funnel
    implements Funnel<OFBsnTlvExternalNetmaskVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvExternalNetmaskVer15Funnel() {
        }

        public void funnel(OFBsnTlvExternalNetmaskVer15 message, PrimitiveSink sink) {
            sink.putShort((short)25);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvExternalNetmask> {
        Reader() {
        }

        @Override
        public OFBsnTlvExternalNetmask readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 25) {
                throw new OFParseError("Wrong type: Expected=0x19(0x19), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvExternalNetmaskVer15 bsnTlvExternalNetmaskVer15 = new OFBsnTlvExternalNetmaskVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvExternalNetmaskVer15);
            }
            return bsnTlvExternalNetmaskVer15;
        }
    }

    static class Builder
    implements OFBsnTlvExternalNetmask.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 25;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalNetmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvExternalNetmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalNetmaskVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvExternalNetmask.Builder {
        final OFBsnTlvExternalNetmaskVer15 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvExternalNetmaskVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 25;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvExternalNetmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvExternalNetmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvExternalNetmaskVer15(value);
        }
    }
}

