/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvDnsAnalytics;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvDnsAnalyticsVer15
implements OFBsnTlvDnsAnalytics {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvDnsAnalyticsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFBsnTlvDnsAnalyticsVer15 DEFAULT = new OFBsnTlvDnsAnalyticsVer15();
    static final OFBsnTlvDnsAnalyticsVer15 INSTANCE = new OFBsnTlvDnsAnalyticsVer15();
    static final Reader READER = new Reader();
    static final OFBsnTlvDnsAnalyticsVer15Funnel FUNNEL = new OFBsnTlvDnsAnalyticsVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvDnsAnalyticsVer15() {
    }

    @Override
    public int getType() {
        return 190;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvDnsAnalytics.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvDnsAnalyticsVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvDnsAnalyticsVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvDnsAnalyticsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvDnsAnalyticsVer15 message) {
            bb.writeShort(190);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvDnsAnalyticsVer15Funnel
    implements Funnel<OFBsnTlvDnsAnalyticsVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvDnsAnalyticsVer15Funnel() {
        }

        public void funnel(OFBsnTlvDnsAnalyticsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)190);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvDnsAnalytics> {
        Reader() {
        }

        @Override
        public OFBsnTlvDnsAnalytics readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 190) {
                throw new OFParseError("Wrong type: Expected=0xbe(0xbe), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

