/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnBfdEndpointState;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBfdState;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnBfdEndpointStateSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBfdStateVer15
implements OFBsnTlvBfdState {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBfdStateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private final OFBsnBfdEndpointState value;
    static final Reader READER = new Reader();
    static final OFBsnTlvBfdStateVer15Funnel FUNNEL = new OFBsnTlvBfdStateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBfdStateVer15(OFBsnBfdEndpointState value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBfdStateVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 177;
    }

    @Override
    public OFBsnBfdEndpointState getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvBfdState.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBfdStateVer15(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBfdStateVer15 other = (OFBsnTlvBfdStateVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBfdStateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBfdStateVer15 message) {
            bb.writeShort(177);
            bb.writeShort(5);
            OFBsnBfdEndpointStateSerializerVer15.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvBfdStateVer15Funnel
    implements Funnel<OFBsnTlvBfdStateVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBfdStateVer15Funnel() {
        }

        public void funnel(OFBsnTlvBfdStateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)177);
            sink.putShort((short)5);
            OFBsnBfdEndpointStateSerializerVer15.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBfdState> {
        Reader() {
        }

        @Override
        public OFBsnTlvBfdState readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 177) {
                throw new OFParseError("Wrong type: Expected=0xb1(0xb1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnBfdEndpointState value = OFBsnBfdEndpointStateSerializerVer15.readFrom(bb);
            OFBsnTlvBfdStateVer15 bsnTlvBfdStateVer15 = new OFBsnTlvBfdStateVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBfdStateVer15);
            }
            return bsnTlvBfdStateVer15;
        }
    }

    static class Builder
    implements OFBsnTlvBfdState.Builder {
        private boolean valueSet;
        private OFBsnBfdEndpointState value;

        Builder() {
        }

        @Override
        public int getType() {
            return 177;
        }

        @Override
        public OFBsnBfdEndpointState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdState.Builder setValue(OFBsnBfdEndpointState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBfdState build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdStateVer15(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBfdState.Builder {
        final OFBsnTlvBfdStateVer15 parentMessage;
        private boolean valueSet;
        private OFBsnBfdEndpointState value;

        BuilderWithParent(OFBsnTlvBfdStateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 177;
        }

        @Override
        public OFBsnBfdEndpointState getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBfdState.Builder setValue(OFBsnBfdEndpointState value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBfdState build() {
            OFBsnBfdEndpointState value;
            OFBsnBfdEndpointState oFBsnBfdEndpointState = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBfdStateVer15(value);
        }
    }
}

