/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnDebugCounterDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnDebugCounterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnFlowChecksumBucketStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGenericStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableBucketStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableEntryDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableEntryStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnGentableStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnImageDescStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLacpStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnPortCounterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnSwitchPipelineStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTableChecksumStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVlanCounterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnVrfCounterStatsRequestVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFBsnStatsRequestVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    public static final Reader READER = new Reader();

    OFBsnStatsRequestVer15() {
    }

    static class Reader
    implements OFMessageReader<OFBsnStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFBsnStatsRequest<?> readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 24) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            bb.readerIndex(start);
            switch (subtype) {
                case 13: {
                    return OFBsnDebugCounterDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 12: {
                    return OFBsnDebugCounterStatsRequestVer15.READER.readFrom(bb);
                }
                case 10: {
                    return OFBsnFlowChecksumBucketStatsRequestVer15.READER.readFrom(bb);
                }
                case 16: {
                    return OFBsnGenericStatsRequestVer15.READER.readFrom(bb);
                }
                case 5: {
                    return OFBsnGentableBucketStatsRequestVer15.READER.readFrom(bb);
                }
                case 4: {
                    return OFBsnGentableDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 2: {
                    return OFBsnGentableEntryDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 3: {
                    return OFBsnGentableEntryStatsRequestVer15.READER.readFrom(bb);
                }
                case 7: {
                    return OFBsnGentableStatsRequestVer15.READER.readFrom(bb);
                }
                case 14: {
                    return OFBsnImageDescStatsRequestVer15.READER.readFrom(bb);
                }
                case 1: {
                    return OFBsnLacpStatsRequestVer15.READER.readFrom(bb);
                }
                case 8: {
                    return OFBsnPortCounterStatsRequestVer15.READER.readFrom(bb);
                }
                case 6: {
                    return OFBsnSwitchPipelineStatsRequestVer15.READER.readFrom(bb);
                }
                case 11: {
                    return OFBsnTableChecksumStatsRequestVer15.READER.readFrom(bb);
                }
                case 9: {
                    return OFBsnVlanCounterStatsRequestVer15.READER.readFrom(bb);
                }
                case 15: {
                    return OFBsnVrfCounterStatsRequestVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator subtype of class OFBsnStatsRequestVer15: " + subtype);
        }
    }
}

