/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnLuaUpload;
import org.projectfloodlight.openflow.protocol.OFBsnLuaUploadFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnLuaUploadFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnLuaUploadVer15
implements OFBsnLuaUpload {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnLuaUploadVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 82;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFBsnLuaUploadFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final String DEFAULT_FILENAME = "";
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final Set<OFBsnLuaUploadFlags> flags;
    private final String filename;
    private final byte[] data;
    static final OFBsnLuaUploadVer15 DEFAULT = new OFBsnLuaUploadVer15(0L, DEFAULT_FLAGS, "", DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnLuaUploadVer15Funnel FUNNEL = new OFBsnLuaUploadVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnLuaUploadVer15(long xid, Set<OFBsnLuaUploadFlags> flags, String filename, byte[] data) {
        if (flags == null) {
            throw new NullPointerException("OFBsnLuaUploadVer15: property flags cannot be null");
        }
        if (filename == null) {
            throw new NullPointerException("OFBsnLuaUploadVer15: property filename cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFBsnLuaUploadVer15: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.filename = filename;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 64L;
    }

    @Override
    public Set<OFBsnLuaUploadFlags> getFlags() {
        return this.flags;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFBsnLuaUpload.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnLuaUploadVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("filename=").append(this.filename);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaUploadVer15 other = (OFBsnLuaUploadVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnLuaUploadVer15 other = (OFBsnLuaUploadVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnLuaUploadVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnLuaUploadVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(64);
            OFBsnLuaUploadFlagsSerializerVer15.writeTo(bb, message.flags);
            ChannelUtils.writeFixedLengthString(bb, message.filename, 64);
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnLuaUploadVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnLuaUploadVer15Funnel
    implements Funnel<OFBsnLuaUploadVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnLuaUploadVer15Funnel() {
        }

        public void funnel(OFBsnLuaUploadVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(64);
            OFBsnLuaUploadFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putUnencodedChars((CharSequence)message.filename);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnLuaUpload> {
        Reader() {
        }

        @Override
        public OFBsnLuaUpload readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 82) {
                throw new OFParseError("Wrong length: Expected to be >= 82, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 64) {
                throw new OFParseError("Wrong subtype: Expected=0x40L(0x40L), got=" + subtype);
            }
            Set<OFBsnLuaUploadFlags> flags = OFBsnLuaUploadFlagsSerializerVer15.readFrom(bb);
            String filename = ChannelUtils.readFixedLengthString(bb, 64);
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnLuaUploadVer15 bsnLuaUploadVer15 = new OFBsnLuaUploadVer15(xid, flags, filename, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnLuaUploadVer15);
            }
            return bsnLuaUploadVer15;
        }
    }

    static class Builder
    implements OFBsnLuaUpload.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFBsnLuaUploadFlags> flags;
        private boolean filenameSet;
        private String filename;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaUpload.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 64L;
        }

        @Override
        public Set<OFBsnLuaUploadFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnLuaUpload.Builder setFlags(Set<OFBsnLuaUploadFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public OFBsnLuaUpload.Builder setFilename(String filename) {
            this.filename = filename;
            this.filenameSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaUpload.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaUpload build() {
            byte[] data;
            String filename;
            Set<OFBsnLuaUploadFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFBsnLuaUploadFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = filename = this.filenameSet ? this.filename : OFBsnLuaUploadVer15.DEFAULT_FILENAME;
            if (filename == null) {
                throw new NullPointerException("Property filename must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaUploadVer15(xid, flags, filename, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnLuaUpload.Builder {
        final OFBsnLuaUploadVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFBsnLuaUploadFlags> flags;
        private boolean filenameSet;
        private String filename;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFBsnLuaUploadVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnLuaUpload.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 64L;
        }

        @Override
        public Set<OFBsnLuaUploadFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnLuaUpload.Builder setFlags(Set<OFBsnLuaUploadFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public OFBsnLuaUpload.Builder setFilename(String filename) {
            this.filename = filename;
            this.filenameSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFBsnLuaUpload.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnLuaUpload build() {
            byte[] data;
            String filename;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            String string = filename = this.filenameSet ? this.filename : this.parentMessage.filename;
            if (filename == null) {
                throw new NullPointerException("Property filename must not be null");
            }
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnLuaUploadVer15(xid, flags, filename, data);
        }
    }
}

