/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigProp;
import org.projectfloodlight.openflow.protocol.OFAsyncGetRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFAsyncConfigPropVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncGetRequestVer15
implements OFAsyncGetRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncGetRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final List<OFAsyncConfigProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final List<OFAsyncConfigProp> properties;
    static final OFAsyncGetRequestVer15 DEFAULT = new OFAsyncGetRequestVer15(0L, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFAsyncGetRequestVer15Funnel FUNNEL = new OFAsyncGetRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncGetRequestVer15(long xid, List<OFAsyncConfigProp> properties) {
        if (properties == null) {
            throw new NullPointerException("OFAsyncGetRequestVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.GET_ASYNC_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public List<OFAsyncConfigProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFAsyncGetRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncGetRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer15 other = (OFAsyncGetRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncGetRequestVer15 other = (OFAsyncGetRequestVer15)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncGetRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncGetRequestVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(26);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFAsyncGetRequestVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFAsyncGetRequestVer15Funnel
    implements Funnel<OFAsyncGetRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncGetRequestVer15Funnel() {
        }

        public void funnel(OFAsyncGetRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)26);
            sink.putLong(message.xid);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncGetRequest> {
        Reader() {
        }

        @Override
        public OFAsyncGetRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 26) {
                throw new OFParseError("Wrong type: Expected=OFType.GET_ASYNC_REQUEST(26), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            List<OFAsyncConfigProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFAsyncConfigPropVer15.READER);
            OFAsyncGetRequestVer15 asyncGetRequestVer15 = new OFAsyncGetRequestVer15(xid, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncGetRequestVer15);
            }
            return asyncGetRequestVer15;
        }
    }

    static class Builder
    implements OFAsyncGetRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncGetRequest build() {
            List<OFAsyncConfigProp> properties;
            long xid = this.xidSet ? this.xid : 0L;
            List<OFAsyncConfigProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncGetRequestVer15(xid, properties);
        }
    }

    static class BuilderWithParent
    implements OFAsyncGetRequest.Builder {
        final OFAsyncGetRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean propertiesSet;
        private List<OFAsyncConfigProp> properties;

        BuilderWithParent(OFAsyncGetRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.GET_ASYNC_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFAsyncGetRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public List<OFAsyncConfigProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFAsyncGetRequest.Builder setProperties(List<OFAsyncConfigProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFAsyncGetRequest build() {
            List properties;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFAsyncGetRequestVer15(xid, properties);
        }
    }
}

