/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFPortStatsPropType;

public class OFPortStatsPropTypeSerializerVer14 {
    public static final short ETHERNET_VAL = 0;
    public static final short OPTICAL_VAL = 1;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFPortStatsPropType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFPortStatsPropTypeSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFPortStatsPropType e) {
        bb.writeShort((int)OFPortStatsPropTypeSerializerVer14.toWireValue(e));
    }

    public static void putTo(OFPortStatsPropType e, PrimitiveSink sink) {
        sink.putShort(OFPortStatsPropTypeSerializerVer14.toWireValue(e));
    }

    public static OFPortStatsPropType ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFPortStatsPropType.ETHERNET;
            }
            case 1: {
                return OFPortStatsPropType.OPTICAL;
            }
            case -1: {
                return OFPortStatsPropType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFPortStatsPropType in version 1.4: " + val);
    }

    public static short toWireValue(OFPortStatsPropType e) {
        switch (e) {
            case ETHERNET: {
                return 0;
            }
            case OPTICAL: {
                return 1;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFPortStatsPropType in version 1.4: " + (Object)((Object)e));
    }
}

