/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnExtendedCapabilities;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnExtendedCapabilitiesVer14
implements OFPortDescPropBsnExtendedCapabilities {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnExtendedCapabilitiesVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 44;
    private static final U64 DEFAULT_CONFIGURABILITY = U64.ZERO;
    private static final U64 DEFAULT_CONFLICT = U64.ZERO;
    private static final U64 DEFAULT_RESERVED1 = U64.ZERO;
    private static final U64 DEFAULT_RESERVED2 = U64.ZERO;
    private final U64 configurability;
    private final U64 conflict;
    private final U64 reserved1;
    private final U64 reserved2;
    static final OFPortDescPropBsnExtendedCapabilitiesVer14 DEFAULT = new OFPortDescPropBsnExtendedCapabilitiesVer14(DEFAULT_CONFIGURABILITY, DEFAULT_CONFLICT, DEFAULT_RESERVED1, DEFAULT_RESERVED2);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnExtendedCapabilitiesVer14Funnel FUNNEL = new OFPortDescPropBsnExtendedCapabilitiesVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnExtendedCapabilitiesVer14(U64 configurability, U64 conflict, U64 reserved1, U64 reserved2) {
        if (configurability == null) {
            throw new NullPointerException("OFPortDescPropBsnExtendedCapabilitiesVer14: property configurability cannot be null");
        }
        if (conflict == null) {
            throw new NullPointerException("OFPortDescPropBsnExtendedCapabilitiesVer14: property conflict cannot be null");
        }
        if (reserved1 == null) {
            throw new NullPointerException("OFPortDescPropBsnExtendedCapabilitiesVer14: property reserved1 cannot be null");
        }
        if (reserved2 == null) {
            throw new NullPointerException("OFPortDescPropBsnExtendedCapabilitiesVer14: property reserved2 cannot be null");
        }
        this.configurability = configurability;
        this.conflict = conflict;
        this.reserved1 = reserved1;
        this.reserved2 = reserved2;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 8L;
    }

    @Override
    public U64 getConfigurability() {
        return this.configurability;
    }

    @Override
    public U64 getConflict() {
        return this.conflict;
    }

    @Override
    public U64 getReserved1() {
        return this.reserved1;
    }

    @Override
    public U64 getReserved2() {
        return this.reserved2;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropBsnExtendedCapabilities.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnExtendedCapabilitiesVer14(");
        b.append("configurability=").append(this.configurability);
        b.append(", ");
        b.append("conflict=").append(this.conflict);
        b.append(", ");
        b.append("reserved1=").append(this.reserved1);
        b.append(", ");
        b.append("reserved2=").append(this.reserved2);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnExtendedCapabilitiesVer14 other = (OFPortDescPropBsnExtendedCapabilitiesVer14)obj;
        if (this.configurability == null ? other.configurability != null : !this.configurability.equals(other.configurability)) {
            return false;
        }
        if (this.conflict == null ? other.conflict != null : !this.conflict.equals(other.conflict)) {
            return false;
        }
        if (this.reserved1 == null ? other.reserved1 != null : !this.reserved1.equals(other.reserved1)) {
            return false;
        }
        return !(this.reserved2 == null ? other.reserved2 != null : !this.reserved2.equals(other.reserved2));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configurability == null ? 0 : this.configurability.hashCode());
        result = 31 * result + (this.conflict == null ? 0 : this.conflict.hashCode());
        result = 31 * result + (this.reserved1 == null ? 0 : this.reserved1.hashCode());
        result = 31 * result + (this.reserved2 == null ? 0 : this.reserved2.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnExtendedCapabilitiesVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnExtendedCapabilitiesVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(44);
            bb.writeInt(6035143);
            bb.writeInt(8);
            bb.writeLong(message.configurability.getValue());
            bb.writeLong(message.conflict.getValue());
            bb.writeLong(message.reserved1.getValue());
            bb.writeLong(message.reserved2.getValue());
        }
    }

    static class OFPortDescPropBsnExtendedCapabilitiesVer14Funnel
    implements Funnel<OFPortDescPropBsnExtendedCapabilitiesVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnExtendedCapabilitiesVer14Funnel() {
        }

        public void funnel(OFPortDescPropBsnExtendedCapabilitiesVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)44);
            sink.putInt(6035143);
            sink.putInt(8);
            message.configurability.putTo(sink);
            message.conflict.putTo(sink);
            message.reserved1.putTo(sink);
            message.reserved2.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnExtendedCapabilities> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 44) {
                throw new OFParseError("Wrong length: Expected=44(44), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 8) {
                throw new OFParseError("Wrong expType: Expected=0x8L(0x8L), got=" + expType);
            }
            U64 configurability = U64.ofRaw(bb.readLong());
            U64 conflict = U64.ofRaw(bb.readLong());
            U64 reserved1 = U64.ofRaw(bb.readLong());
            U64 reserved2 = U64.ofRaw(bb.readLong());
            OFPortDescPropBsnExtendedCapabilitiesVer14 portDescPropBsnExtendedCapabilitiesVer14 = new OFPortDescPropBsnExtendedCapabilitiesVer14(configurability, conflict, reserved1, reserved2);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnExtendedCapabilitiesVer14);
            }
            return portDescPropBsnExtendedCapabilitiesVer14;
        }
    }

    static class Builder
    implements OFPortDescPropBsnExtendedCapabilities.Builder {
        private boolean configurabilitySet;
        private U64 configurability;
        private boolean conflictSet;
        private U64 conflict;
        private boolean reserved1Set;
        private U64 reserved1;
        private boolean reserved2Set;
        private U64 reserved2;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 8L;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getConfigurability() {
            return this.configurability;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setConfigurability(U64 configurability) {
            this.configurability = configurability;
            this.configurabilitySet = true;
            return this;
        }

        @Override
        public U64 getConflict() {
            return this.conflict;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setConflict(U64 conflict) {
            this.conflict = conflict;
            this.conflictSet = true;
            return this;
        }

        @Override
        public U64 getReserved1() {
            return this.reserved1;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setReserved1(U64 reserved1) {
            this.reserved1 = reserved1;
            this.reserved1Set = true;
            return this;
        }

        @Override
        public U64 getReserved2() {
            return this.reserved2;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setReserved2(U64 reserved2) {
            this.reserved2 = reserved2;
            this.reserved2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities build() {
            U64 reserved2;
            U64 reserved1;
            U64 conflict;
            U64 configurability;
            U64 u64 = configurability = this.configurabilitySet ? this.configurability : DEFAULT_CONFIGURABILITY;
            if (configurability == null) {
                throw new NullPointerException("Property configurability must not be null");
            }
            U64 u642 = conflict = this.conflictSet ? this.conflict : DEFAULT_CONFLICT;
            if (conflict == null) {
                throw new NullPointerException("Property conflict must not be null");
            }
            U64 u643 = reserved1 = this.reserved1Set ? this.reserved1 : DEFAULT_RESERVED1;
            if (reserved1 == null) {
                throw new NullPointerException("Property reserved1 must not be null");
            }
            U64 u644 = reserved2 = this.reserved2Set ? this.reserved2 : DEFAULT_RESERVED2;
            if (reserved2 == null) {
                throw new NullPointerException("Property reserved2 must not be null");
            }
            return new OFPortDescPropBsnExtendedCapabilitiesVer14(configurability, conflict, reserved1, reserved2);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnExtendedCapabilities.Builder {
        final OFPortDescPropBsnExtendedCapabilitiesVer14 parentMessage;
        private boolean configurabilitySet;
        private U64 configurability;
        private boolean conflictSet;
        private U64 conflict;
        private boolean reserved1Set;
        private U64 reserved1;
        private boolean reserved2Set;
        private U64 reserved2;

        BuilderWithParent(OFPortDescPropBsnExtendedCapabilitiesVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 8L;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public U64 getConfigurability() {
            return this.configurability;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setConfigurability(U64 configurability) {
            this.configurability = configurability;
            this.configurabilitySet = true;
            return this;
        }

        @Override
        public U64 getConflict() {
            return this.conflict;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setConflict(U64 conflict) {
            this.conflict = conflict;
            this.conflictSet = true;
            return this;
        }

        @Override
        public U64 getReserved1() {
            return this.reserved1;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setReserved1(U64 reserved1) {
            this.reserved1 = reserved1;
            this.reserved1Set = true;
            return this;
        }

        @Override
        public U64 getReserved2() {
            return this.reserved2;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities.Builder setReserved2(U64 reserved2) {
            this.reserved2 = reserved2;
            this.reserved2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnExtendedCapabilities build() {
            U64 reserved2;
            U64 reserved1;
            U64 conflict;
            U64 configurability;
            U64 u64 = configurability = this.configurabilitySet ? this.configurability : this.parentMessage.configurability;
            if (configurability == null) {
                throw new NullPointerException("Property configurability must not be null");
            }
            U64 u642 = conflict = this.conflictSet ? this.conflict : this.parentMessage.conflict;
            if (conflict == null) {
                throw new NullPointerException("Property conflict must not be null");
            }
            U64 u643 = reserved1 = this.reserved1Set ? this.reserved1 : this.parentMessage.reserved1;
            if (reserved1 == null) {
                throw new NullPointerException("Property reserved1 must not be null");
            }
            U64 u644 = reserved2 = this.reserved2Set ? this.reserved2 : this.parentMessage.reserved2;
            if (reserved2 == null) {
                throw new NullPointerException("Property reserved2 must not be null");
            }
            return new OFPortDescPropBsnExtendedCapabilitiesVer14(configurability, conflict, reserved1, reserved2);
        }
    }
}

