/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Exthdr;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6ExthdrVer14
implements OFOxmIpv6Exthdr {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6ExthdrVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmIpv6ExthdrVer14 DEFAULT = new OFOxmIpv6ExthdrVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpv6ExthdrVer14Funnel FUNNEL = new OFOxmIpv6ExthdrVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6ExthdrVer14(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6ExthdrVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147503618L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.IPV6_EXTHDR;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpv6Exthdr.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6ExthdrVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6ExthdrVer14 other = (OFOxmIpv6ExthdrVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6ExthdrVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpv6ExthdrVer14 message) {
            bb.writeInt(-2147463678);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmIpv6ExthdrVer14Funnel
    implements Funnel<OFOxmIpv6ExthdrVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6ExthdrVer14Funnel() {
        }

        public void funnel(OFOxmIpv6ExthdrVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147463678);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6Exthdr> {
        Reader() {
        }

        @Override
        public OFOxmIpv6Exthdr readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147463678) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004e02L(0x80004e02L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmIpv6ExthdrVer14 oxmIpv6ExthdrVer14 = new OFOxmIpv6ExthdrVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6ExthdrVer14);
            }
            return oxmIpv6ExthdrVer14;
        }
    }

    static class Builder
    implements OFOxmIpv6Exthdr.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147503618L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Exthdr.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.IPV6_EXTHDR;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6Exthdr build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6ExthdrVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6Exthdr.Builder {
        final OFOxmIpv6ExthdrVer14 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmIpv6ExthdrVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147503618L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Exthdr.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.IPV6_EXTHDR;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6Exthdr build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6ExthdrVer14(value);
        }
    }
}

