/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMeterFlags;

public class OFMeterFlagsSerializerVer14 {
    public static final short KBPS_VAL = 1;
    public static final short PKTPS_VAL = 2;
    public static final short BURST_VAL = 4;
    public static final short STATS_VAL = 8;

    public static Set<OFMeterFlags> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFMeterFlagsSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFMeterFlags> set) {
        bb.writeShort((int)OFMeterFlagsSerializerVer14.toWireValue(set));
    }

    public static void putTo(Set<OFMeterFlags> set, PrimitiveSink sink) {
        sink.putShort(OFMeterFlagsSerializerVer14.toWireValue(set));
    }

    public static Set<OFMeterFlags> ofWireValue(short val) {
        EnumSet<OFMeterFlags> set = EnumSet.noneOf(OFMeterFlags.class);
        if ((val & 1) != 0) {
            set.add(OFMeterFlags.KBPS);
        }
        if ((val & 2) != 0) {
            set.add(OFMeterFlags.PKTPS);
        }
        if ((val & 4) != 0) {
            set.add(OFMeterFlags.BURST);
        }
        if ((val & 8) != 0) {
            set.add(OFMeterFlags.STATS);
        }
        return Collections.unmodifiableSet(set);
    }

    public static short toWireValue(Set<OFMeterFlags> set) {
        short wireValue = 0;
        block6: for (OFMeterFlags e : set) {
            switch (e) {
                case KBPS: {
                    wireValue = (short)(wireValue | 1);
                    continue block6;
                }
                case PKTPS: {
                    wireValue = (short)(wireValue | 2);
                    continue block6;
                }
                case BURST: {
                    wireValue = (short)(wireValue | 4);
                    continue block6;
                }
                case STATS: {
                    wireValue = (short)(wireValue | 8);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFMeterFlags in version 1.4: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

