/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnPortUsage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPortUsage;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnPortUsageSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortUsageVer14
implements OFBsnTlvPortUsage {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortUsageVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private final OFBsnPortUsage value;
    static final Reader READER = new Reader();
    static final OFBsnTlvPortUsageVer14Funnel FUNNEL = new OFBsnTlvPortUsageVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortUsageVer14(OFBsnPortUsage value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortUsageVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 141;
    }

    @Override
    public OFBsnPortUsage getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvPortUsage.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortUsageVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortUsageVer14 other = (OFBsnTlvPortUsageVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortUsageVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvPortUsageVer14 message) {
            bb.writeShort(141);
            bb.writeShort(6);
            OFBsnPortUsageSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvPortUsageVer14Funnel
    implements Funnel<OFBsnTlvPortUsageVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortUsageVer14Funnel() {
        }

        public void funnel(OFBsnTlvPortUsageVer14 message, PrimitiveSink sink) {
            sink.putShort((short)141);
            sink.putShort((short)6);
            OFBsnPortUsageSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPortUsage> {
        Reader() {
        }

        @Override
        public OFBsnTlvPortUsage readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 141) {
                throw new OFParseError("Wrong type: Expected=0x8d(0x8d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnPortUsage value = OFBsnPortUsageSerializerVer14.readFrom(bb);
            OFBsnTlvPortUsageVer14 bsnTlvPortUsageVer14 = new OFBsnTlvPortUsageVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortUsageVer14);
            }
            return bsnTlvPortUsageVer14;
        }
    }

    static class Builder
    implements OFBsnTlvPortUsage.Builder {
        private boolean valueSet;
        private OFBsnPortUsage value;

        Builder() {
        }

        @Override
        public int getType() {
            return 141;
        }

        @Override
        public OFBsnPortUsage getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortUsage.Builder setValue(OFBsnPortUsage value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPortUsage build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortUsageVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPortUsage.Builder {
        final OFBsnTlvPortUsageVer14 parentMessage;
        private boolean valueSet;
        private OFBsnPortUsage value;

        BuilderWithParent(OFBsnTlvPortUsageVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 141;
        }

        @Override
        public OFBsnPortUsage getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPortUsage.Builder setValue(OFBsnPortUsage value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvPortUsage build() {
            OFBsnPortUsage value;
            OFBsnPortUsage oFBsnPortUsage = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortUsageVer14(value);
        }
    }
}

