/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv4Dst;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv4DstVer14
implements OFBsnTlvIpv4Dst {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv4DstVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvIpv4DstVer14 DEFAULT = new OFBsnTlvIpv4DstVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv4DstVer14Funnel FUNNEL = new OFBsnTlvIpv4DstVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv4DstVer14(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv4DstVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 35;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpv4Dst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv4DstVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv4DstVer14 other = (OFBsnTlvIpv4DstVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv4DstVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpv4DstVer14 message) {
            bb.writeShort(35);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvIpv4DstVer14Funnel
    implements Funnel<OFBsnTlvIpv4DstVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv4DstVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpv4DstVer14 message, PrimitiveSink sink) {
            sink.putShort((short)35);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv4Dst> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv4Dst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 35) {
                throw new OFParseError("Wrong type: Expected=0x23(0x23), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvIpv4DstVer14 bsnTlvIpv4DstVer14 = new OFBsnTlvIpv4DstVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv4DstVer14);
            }
            return bsnTlvIpv4DstVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpv4Dst.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 35;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Dst.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv4Dst build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4DstVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv4Dst.Builder {
        final OFBsnTlvIpv4DstVer14 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvIpv4DstVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 35;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Dst.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpv4Dst build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4DstVer14(value);
        }
    }
}

