/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashPacketField;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashPacketField;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnHashPacketFieldSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashPacketFieldVer14
implements OFBsnTlvHashPacketField {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashPacketFieldVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final Set<OFBsnHashPacketField> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnHashPacketField> value;
    static final OFBsnTlvHashPacketFieldVer14 DEFAULT = new OFBsnTlvHashPacketFieldVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvHashPacketFieldVer14Funnel FUNNEL = new OFBsnTlvHashPacketFieldVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashPacketFieldVer14(Set<OFBsnHashPacketField> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashPacketFieldVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public Set<OFBsnHashPacketField> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvHashPacketField.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashPacketFieldVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashPacketFieldVer14 other = (OFBsnTlvHashPacketFieldVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashPacketFieldVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashPacketFieldVer14 message) {
            bb.writeShort(103);
            bb.writeShort(12);
            OFBsnHashPacketFieldSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashPacketFieldVer14Funnel
    implements Funnel<OFBsnTlvHashPacketFieldVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashPacketFieldVer14Funnel() {
        }

        public void funnel(OFBsnTlvHashPacketFieldVer14 message, PrimitiveSink sink) {
            sink.putShort((short)103);
            sink.putShort((short)12);
            OFBsnHashPacketFieldSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashPacketField> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashPacketField readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 103) {
                throw new OFParseError("Wrong type: Expected=0x67(0x67), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnHashPacketField> value = OFBsnHashPacketFieldSerializerVer14.readFrom(bb);
            OFBsnTlvHashPacketFieldVer14 bsnTlvHashPacketFieldVer14 = new OFBsnTlvHashPacketFieldVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashPacketFieldVer14);
            }
            return bsnTlvHashPacketFieldVer14;
        }
    }

    static class Builder
    implements OFBsnTlvHashPacketField.Builder {
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set<OFBsnHashPacketField> value;
            Set<OFBsnHashPacketField> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashPacketField.Builder {
        final OFBsnTlvHashPacketFieldVer14 parentMessage;
        private boolean valueSet;
        private Set<OFBsnHashPacketField> value;

        BuilderWithParent(OFBsnTlvHashPacketFieldVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 103;
        }

        @Override
        public Set<OFBsnHashPacketField> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketField.Builder setValue(Set<OFBsnHashPacketField> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashPacketField build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketFieldVer14(value);
        }
    }
}

