/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBroadcastQueryTimeout;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBroadcastQueryTimeoutVer14
implements OFBsnTlvBroadcastQueryTimeout {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBroadcastQueryTimeoutVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvBroadcastQueryTimeoutVer14 DEFAULT = new OFBsnTlvBroadcastQueryTimeoutVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvBroadcastQueryTimeoutVer14Funnel FUNNEL = new OFBsnTlvBroadcastQueryTimeoutVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBroadcastQueryTimeoutVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvBroadcastQueryTimeout.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBroadcastQueryTimeoutVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBroadcastQueryTimeoutVer14 other = (OFBsnTlvBroadcastQueryTimeoutVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBroadcastQueryTimeoutVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBroadcastQueryTimeoutVer14 message) {
            bb.writeShort(10);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvBroadcastQueryTimeoutVer14Funnel
    implements Funnel<OFBsnTlvBroadcastQueryTimeoutVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBroadcastQueryTimeoutVer14Funnel() {
        }

        public void funnel(OFBsnTlvBroadcastQueryTimeoutVer14 message, PrimitiveSink sink) {
            sink.putShort((short)10);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBroadcastQueryTimeout> {
        Reader() {
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=0xa(0xa), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvBroadcastQueryTimeoutVer14 bsnTlvBroadcastQueryTimeoutVer14 = new OFBsnTlvBroadcastQueryTimeoutVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBroadcastQueryTimeoutVer14);
            }
            return bsnTlvBroadcastQueryTimeoutVer14;
        }
    }

    static class Builder
    implements OFBsnTlvBroadcastQueryTimeout.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvBroadcastQueryTimeoutVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBroadcastQueryTimeout.Builder {
        final OFBsnTlvBroadcastQueryTimeoutVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvBroadcastQueryTimeoutVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 10;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvBroadcastQueryTimeout build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvBroadcastQueryTimeoutVer14(value);
        }
    }
}

