/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvApplyBytes;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvApplyBytesVer14
implements OFBsnTlvApplyBytes {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvApplyBytesVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFBsnTlvApplyBytesVer14 DEFAULT = new OFBsnTlvApplyBytesVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvApplyBytesVer14Funnel FUNNEL = new OFBsnTlvApplyBytesVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvApplyBytesVer14(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvApplyBytesVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 130;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvApplyBytes.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvApplyBytesVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvApplyBytesVer14 other = (OFBsnTlvApplyBytesVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvApplyBytesVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvApplyBytesVer14 message) {
            bb.writeShort(130);
            bb.writeShort(12);
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFBsnTlvApplyBytesVer14Funnel
    implements Funnel<OFBsnTlvApplyBytesVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvApplyBytesVer14Funnel() {
        }

        public void funnel(OFBsnTlvApplyBytesVer14 message, PrimitiveSink sink) {
            sink.putShort((short)130);
            sink.putShort((short)12);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvApplyBytes> {
        Reader() {
        }

        @Override
        public OFBsnTlvApplyBytes readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 130) {
                throw new OFParseError("Wrong type: Expected=0x82(0x82), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            U64 value = U64.ofRaw(bb.readLong());
            OFBsnTlvApplyBytesVer14 bsnTlvApplyBytesVer14 = new OFBsnTlvApplyBytesVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvApplyBytesVer14);
            }
            return bsnTlvApplyBytesVer14;
        }
    }

    static class Builder
    implements OFBsnTlvApplyBytes.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public int getType() {
            return 130;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvApplyBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvApplyBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvApplyBytesVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvApplyBytes.Builder {
        final OFBsnTlvApplyBytesVer14 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFBsnTlvApplyBytesVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 130;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvApplyBytes.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvApplyBytes build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvApplyBytesVer14(value);
        }
    }
}

