/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableErrorCode;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBsnGentableError;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnGentableErrorCodeSerializerVer14;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableErrorVer14
implements OFBsnGentableError {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableErrorVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 276;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final String DEFAULT_ERR_MSG = "";
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFBsnGentableErrorCode errorCode;
    private final GenTableId tableId;
    private final String errMsg;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFBsnGentableErrorVer14Funnel FUNNEL = new OFBsnGentableErrorVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableErrorVer14(long xid, OFBsnGentableErrorCode errorCode, GenTableId tableId, String errMsg, OFErrorCauseData data) {
        if (errorCode == null) {
            throw new NullPointerException("OFBsnGentableErrorVer14: property errorCode cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableErrorVer14: property tableId cannot be null");
        }
        if (errMsg == null) {
            throw new NullPointerException("OFBsnGentableErrorVer14: property errMsg cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFBsnGentableErrorVer14: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.errorCode = errorCode;
        this.tableId = tableId;
        this.errMsg = errMsg;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return 2;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public OFBsnGentableErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFBsnGentableError.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableErrorVer14(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("errorCode=").append((Object)this.errorCode);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("errMsg=").append(this.errMsg);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableErrorVer14 other = (OFBsnGentableErrorVer14)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals((Object)other.errorCode)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.errMsg == null ? other.errMsg != null : !this.errMsg.equals(other.errMsg)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableErrorVer14 other = (OFBsnGentableErrorVer14)obj;
        if (this.errorCode == null ? other.errorCode != null : !this.errorCode.equals((Object)other.errorCode)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.errMsg == null ? other.errMsg != null : !this.errMsg.equals(other.errMsg)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.errMsg == null ? 0 : this.errMsg.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errorCode == null ? 0 : this.errorCode.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.errMsg == null ? 0 : this.errMsg.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableErrorVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableErrorVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(5);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            bb.writeShort(2);
            bb.writeInt(6035143);
            OFBsnGentableErrorCodeSerializerVer14.writeTo(bb, message.errorCode);
            message.tableId.write2Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.errMsg, 256);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGentableErrorVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGentableErrorVer14Funnel
    implements Funnel<OFBsnGentableErrorVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableErrorVer14Funnel() {
        }

        public void funnel(OFBsnGentableErrorVer14 message, PrimitiveSink sink) {
            sink.putByte((byte)5);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            sink.putShort((short)2);
            sink.putInt(6035143);
            OFBsnGentableErrorCodeSerializerVer14.putTo(message.errorCode, sink);
            message.tableId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.errMsg);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableError> {
        Reader() {
        }

        @Override
        public OFBsnGentableError readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 5) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_14(5), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 276) {
                throw new OFParseError("Wrong length: Expected to be >= 276, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != -1) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got=" + errType);
            }
            short subtype = bb.readShort();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2(0x2), got=" + subtype);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            OFBsnGentableErrorCode errorCode = OFBsnGentableErrorCodeSerializerVer14.readFrom(bb);
            GenTableId tableId = GenTableId.read2Bytes(bb);
            String errMsg = ChannelUtils.readFixedLengthString(bb, 256);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_14);
            OFBsnGentableErrorVer14 bsnGentableErrorVer14 = new OFBsnGentableErrorVer14(xid, errorCode, tableId, errMsg, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableErrorVer14);
            }
            return bsnGentableErrorVer14;
        }
    }

    static class Builder
    implements OFBsnGentableError.Builder {
        private boolean xidSet;
        private long xid;
        private boolean errorCodeSet;
        private OFBsnGentableErrorCode errorCode;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableError.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return 2;
        }

        @Override
        public OFBsnGentableError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public OFBsnGentableErrorCode getErrorCode() {
            return this.errorCode;
        }

        @Override
        public OFBsnGentableError.Builder setErrorCode(OFBsnGentableErrorCode errorCode) {
            this.errorCode = errorCode;
            this.errorCodeSet = true;
            return this;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableError.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        @Override
        public OFBsnGentableError.Builder setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            this.errMsgSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFBsnGentableError.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnGentableError build() {
            OFErrorCauseData data;
            String errMsg;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.errorCodeSet) {
                throw new IllegalStateException("Property errorCode doesn't have default value -- must be set");
            }
            if (this.errorCode == null) {
                throw new NullPointerException("Property errorCode must not be null");
            }
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = errMsg = this.errMsgSet ? this.errMsg : OFBsnGentableErrorVer14.DEFAULT_ERR_MSG;
            if (errMsg == null) {
                throw new NullPointerException("Property errMsg must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnGentableErrorVer14(xid, this.errorCode, this.tableId, errMsg, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableError.Builder {
        final OFBsnGentableErrorVer14 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean errorCodeSet;
        private OFBsnGentableErrorCode errorCode;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFBsnGentableErrorVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableError.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return 2;
        }

        @Override
        public OFBsnGentableError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public OFBsnGentableErrorCode getErrorCode() {
            return this.errorCode;
        }

        @Override
        public OFBsnGentableError.Builder setErrorCode(OFBsnGentableErrorCode errorCode) {
            this.errorCode = errorCode;
            this.errorCodeSet = true;
            return this;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableError.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        @Override
        public OFBsnGentableError.Builder setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            this.errMsgSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFBsnGentableError.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnGentableError build() {
            OFErrorCauseData data;
            String errMsg;
            GenTableId tableId;
            OFBsnGentableErrorCode errorCode;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFBsnGentableErrorCode oFBsnGentableErrorCode = errorCode = this.errorCodeSet ? this.errorCode : this.parentMessage.errorCode;
            if (errorCode == null) {
                throw new NullPointerException("Property errorCode must not be null");
            }
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = errMsg = this.errMsgSet ? this.errMsg : this.parentMessage.errMsg;
            if (errMsg == null) {
                throw new NullPointerException("Property errMsg must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnGentableErrorVer14(xid, errorCode, tableId, errMsg, data);
        }
    }
}

