/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionPopVlan;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionPopVlanVer14
implements OFActionPopVlan {
    private static final Logger logger = LoggerFactory.getLogger(OFActionPopVlanVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    static final OFActionPopVlanVer14 DEFAULT = new OFActionPopVlanVer14();
    static final OFActionPopVlanVer14 INSTANCE = new OFActionPopVlanVer14();
    static final Reader READER = new Reader();
    static final OFActionPopVlanVer14Funnel FUNNEL = new OFActionPopVlanVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionPopVlanVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.POP_VLAN;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionPopVlan.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionPopVlanVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionPopVlanVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionPopVlanVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionPopVlanVer14 message) {
            bb.writeShort(18);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionPopVlanVer14Funnel
    implements Funnel<OFActionPopVlanVer14> {
        private static final long serialVersionUID = 1L;

        OFActionPopVlanVer14Funnel() {
        }

        public void funnel(OFActionPopVlanVer14 message, PrimitiveSink sink) {
            sink.putShort((short)18);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionPopVlan> {
        Reader() {
        }

        @Override
        public OFActionPopVlan readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFActionType.POP_VLAN(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

