/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdBsnSetTunnelDst;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdBsnSetTunnelDstVer14
implements OFActionIdBsnSetTunnelDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdBsnSetTunnelDstVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    static final OFActionIdBsnSetTunnelDstVer14 DEFAULT = new OFActionIdBsnSetTunnelDstVer14();
    static final OFActionIdBsnSetTunnelDstVer14 INSTANCE = new OFActionIdBsnSetTunnelDstVer14();
    static final Reader READER = new Reader();
    static final OFActionIdBsnSetTunnelDstVer14Funnel FUNNEL = new OFActionIdBsnSetTunnelDstVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdBsnSetTunnelDstVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionIdBsnSetTunnelDst.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdBsnSetTunnelDstVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdBsnSetTunnelDstVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdBsnSetTunnelDstVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdBsnSetTunnelDstVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(12);
            bb.writeInt(6035143);
            bb.writeInt(2);
        }
    }

    static class OFActionIdBsnSetTunnelDstVer14Funnel
    implements Funnel<OFActionIdBsnSetTunnelDstVer14> {
        private static final long serialVersionUID = 1L;

        OFActionIdBsnSetTunnelDstVer14Funnel() {
        }

        public void funnel(OFActionIdBsnSetTunnelDstVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)12);
            sink.putInt(6035143);
            sink.putInt(2);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdBsnSetTunnelDst> {
        Reader() {
        }

        @Override
        public OFActionIdBsnSetTunnelDst readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

