/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnLagIdMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnLagIdVer13;
import org.projectfloodlight.openflow.types.LagId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnLagIdMaskedVer13
implements OFOxmBsnLagIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnLagIdMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    private static final LagId DEFAULT_VALUE = LagId.NONE;
    private static final LagId DEFAULT_VALUE_MASK = LagId.NONE;
    private final LagId value;
    private final LagId mask;
    static final OFOxmBsnLagIdMaskedVer13 DEFAULT = new OFOxmBsnLagIdMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnLagIdMaskedVer13Funnel FUNNEL = new OFOxmBsnLagIdMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnLagIdMaskedVer13(LagId value, LagId mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnLagIdMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnLagIdMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 197384L;
    }

    @Override
    public LagId getValue() {
        return this.value;
    }

    @Override
    public LagId getMask() {
        return this.mask;
    }

    @Override
    public MatchField<LagId> getMatchField() {
        return MatchField.BSN_LAG_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<LagId> getCanonical() {
        if (LagId.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnLagIdVer13(this.value);
        }
        if (LagId.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnLagIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnLagIdMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnLagIdMaskedVer13 other = (OFOxmBsnLagIdMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnLagIdMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnLagIdMaskedVer13 message) {
            bb.writeInt(197384);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnLagIdMaskedVer13Funnel
    implements Funnel<OFOxmBsnLagIdMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnLagIdMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnLagIdMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(197384);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnLagIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnLagIdMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 197384) {
                throw new OFParseError("Wrong typeLen: Expected=0x30308L(0x30308L), got=" + typeLen);
            }
            LagId value = LagId.read4Bytes(bb);
            LagId mask = LagId.read4Bytes(bb);
            OFOxmBsnLagIdMaskedVer13 oxmBsnLagIdMaskedVer13 = new OFOxmBsnLagIdMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnLagIdMaskedVer13);
            }
            return oxmBsnLagIdMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnLagIdMasked.Builder {
        private boolean valueSet;
        private LagId value;
        private boolean maskSet;
        private LagId mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 197384L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagIdMasked.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public LagId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnLagIdMasked.Builder setMask(LagId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnLagIdMasked build() {
            LagId mask;
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            LagId lagId2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnLagIdMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnLagIdMasked.Builder {
        final OFOxmBsnLagIdMaskedVer13 parentMessage;
        private boolean valueSet;
        private LagId value;
        private boolean maskSet;
        private LagId mask;

        BuilderWithParent(OFOxmBsnLagIdMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 197384L;
        }

        @Override
        public LagId getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnLagIdMasked.Builder setValue(LagId value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public LagId getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnLagIdMasked.Builder setMask(LagId mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<LagId> getMatchField() {
            return MatchField.BSN_LAG_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<LagId> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnLagIdMasked build() {
            LagId mask;
            LagId value;
            LagId lagId = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            LagId lagId2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnLagIdMaskedVer13(value, mask);
        }
    }
}

