/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnIpFragmentationMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnIpFragmentationVer13;
import org.projectfloodlight.openflow.types.OFBooleanValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnIpFragmentationMaskedVer13
implements OFOxmBsnIpFragmentationMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnIpFragmentationMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final OFBooleanValue DEFAULT_VALUE = OFBooleanValue.FALSE;
    private static final OFBooleanValue DEFAULT_VALUE_MASK = OFBooleanValue.FALSE;
    private final OFBooleanValue value;
    private final OFBooleanValue mask;
    static final OFOxmBsnIpFragmentationMaskedVer13 DEFAULT = new OFOxmBsnIpFragmentationMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnIpFragmentationMaskedVer13Funnel FUNNEL = new OFOxmBsnIpFragmentationMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnIpFragmentationMaskedVer13(OFBooleanValue value, OFBooleanValue mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnIpFragmentationMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnIpFragmentationMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 210178L;
    }

    @Override
    public OFBooleanValue getValue() {
        return this.value;
    }

    @Override
    public OFBooleanValue getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFBooleanValue> getMatchField() {
        return MatchField.BSN_IP_FRAGMENTATION;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFBooleanValue> getCanonical() {
        if (OFBooleanValue.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnIpFragmentationVer13(this.value);
        }
        if (OFBooleanValue.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnIpFragmentationMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnIpFragmentationMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnIpFragmentationMaskedVer13 other = (OFOxmBsnIpFragmentationMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnIpFragmentationMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnIpFragmentationMaskedVer13 message) {
            bb.writeInt(210178);
            bb.writeByte(message.value.getInt());
            bb.writeByte(message.mask.getInt());
        }
    }

    static class OFOxmBsnIpFragmentationMaskedVer13Funnel
    implements Funnel<OFOxmBsnIpFragmentationMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnIpFragmentationMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnIpFragmentationMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(210178);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnIpFragmentationMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnIpFragmentationMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 210178) {
                throw new OFParseError("Wrong typeLen: Expected=0x33502L(0x33502L), got=" + typeLen);
            }
            OFBooleanValue value = OFBooleanValue.of(bb.readByte() != 0);
            OFBooleanValue mask = OFBooleanValue.of(bb.readByte() != 0);
            OFOxmBsnIpFragmentationMaskedVer13 oxmBsnIpFragmentationMaskedVer13 = new OFOxmBsnIpFragmentationMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnIpFragmentationMaskedVer13);
            }
            return oxmBsnIpFragmentationMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnIpFragmentationMasked.Builder {
        private boolean valueSet;
        private OFBooleanValue value;
        private boolean maskSet;
        private OFBooleanValue mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 210178L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBooleanValue getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked.Builder setMask(OFBooleanValue mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_IP_FRAGMENTATION;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked build() {
            OFBooleanValue mask;
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBooleanValue oFBooleanValue2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnIpFragmentationMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnIpFragmentationMasked.Builder {
        final OFOxmBsnIpFragmentationMaskedVer13 parentMessage;
        private boolean valueSet;
        private OFBooleanValue value;
        private boolean maskSet;
        private OFBooleanValue mask;

        BuilderWithParent(OFOxmBsnIpFragmentationMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 210178L;
        }

        @Override
        public OFBooleanValue getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked.Builder setValue(OFBooleanValue value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFBooleanValue getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked.Builder setMask(OFBooleanValue mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFBooleanValue> getMatchField() {
            return MatchField.BSN_IP_FRAGMENTATION;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFBooleanValue> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnIpFragmentationMasked build() {
            OFBooleanValue mask;
            OFBooleanValue value;
            OFBooleanValue oFBooleanValue = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFBooleanValue oFBooleanValue2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnIpFragmentationMaskedVer13(value, mask);
        }
    }
}

