/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver13.OFAsyncGetReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFAsyncGetRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFAsyncSetVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBarrierReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFBarrierRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFEchoReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFEchoRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFErrorMsgVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFExperimenterVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFeaturesReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFeaturesRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowModVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowRemovedVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGetConfigReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGetConfigRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupModVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFHelloVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterModVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPacketInVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPacketOutVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortModVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStatusVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFQueueGetConfigReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFQueueGetConfigRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFRoleReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFRoleRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFSetConfigVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableModVer13;

abstract class OFMessageVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFMessageVer13() {
    }

    static class Reader
    implements OFMessageReader<OFMessage> {
        Reader() {
        }

        @Override
        public OFMessage readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            bb.readerIndex(start);
            switch (type) {
                case 19: {
                    return OFStatsReplyVer13.READER.readFrom(bb);
                }
                case 18: {
                    return OFStatsRequestVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFErrorMsgVer13.READER.readFrom(bb);
                }
                case 21: {
                    return OFBarrierReplyVer13.READER.readFrom(bb);
                }
                case 20: {
                    return OFBarrierRequestVer13.READER.readFrom(bb);
                }
                case 4: {
                    return OFExperimenterVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFEchoReplyVer13.READER.readFrom(bb);
                }
                case 2: {
                    return OFEchoRequestVer13.READER.readFrom(bb);
                }
                case 6: {
                    return OFFeaturesReplyVer13.READER.readFrom(bb);
                }
                case 5: {
                    return OFFeaturesRequestVer13.READER.readFrom(bb);
                }
                case 14: {
                    return OFFlowModVer13.READER.readFrom(bb);
                }
                case 11: {
                    return OFFlowRemovedVer13.READER.readFrom(bb);
                }
                case 8: {
                    return OFGetConfigReplyVer13.READER.readFrom(bb);
                }
                case 7: {
                    return OFGetConfigRequestVer13.READER.readFrom(bb);
                }
                case 0: {
                    return OFHelloVer13.READER.readFrom(bb);
                }
                case 10: {
                    return OFPacketInVer13.READER.readFrom(bb);
                }
                case 13: {
                    return OFPacketOutVer13.READER.readFrom(bb);
                }
                case 16: {
                    return OFPortModVer13.READER.readFrom(bb);
                }
                case 12: {
                    return OFPortStatusVer13.READER.readFrom(bb);
                }
                case 23: {
                    return OFQueueGetConfigReplyVer13.READER.readFrom(bb);
                }
                case 22: {
                    return OFQueueGetConfigRequestVer13.READER.readFrom(bb);
                }
                case 9: {
                    return OFSetConfigVer13.READER.readFrom(bb);
                }
                case 17: {
                    return OFTableModVer13.READER.readFrom(bb);
                }
                case 15: {
                    return OFGroupModVer13.READER.readFrom(bb);
                }
                case 25: {
                    return OFRoleReplyVer13.READER.readFrom(bb);
                }
                case 24: {
                    return OFRoleRequestVer13.READER.readFrom(bb);
                }
                case 27: {
                    return OFAsyncGetReplyVer13.READER.readFrom(bb);
                }
                case 26: {
                    return OFAsyncGetRequestVer13.READER.readFrom(bb);
                }
                case 28: {
                    return OFAsyncSetVer13.READER.readFrom(bb);
                }
                case 29: {
                    return OFMeterModVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator type of class OFMessageVer13: " + type);
        }
    }
}

