/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionMeter;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionMeterVer13
implements OFInstructionMeter {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionMeterVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final long DEFAULT_METER_ID = 0L;
    private final long meterId;
    static final OFInstructionMeterVer13 DEFAULT = new OFInstructionMeterVer13(0L);
    static final Reader READER = new Reader();
    static final OFInstructionMeterVer13Funnel FUNNEL = new OFInstructionMeterVer13Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionMeterVer13(long meterId) {
        this.meterId = U32.normalize(meterId);
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.METER;
    }

    @Override
    public long getMeterId() {
        return this.meterId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFInstructionMeter.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionMeterVer13(");
        b.append("meterId=").append(this.meterId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionMeterVer13 other = (OFInstructionMeterVer13)obj;
        return this.meterId == other.meterId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.meterId ^ this.meterId >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionMeterVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionMeterVer13 message) {
            bb.writeShort(6);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.meterId));
        }
    }

    static class OFInstructionMeterVer13Funnel
    implements Funnel<OFInstructionMeterVer13> {
        private static final long serialVersionUID = 1L;

        OFInstructionMeterVer13Funnel() {
        }

        public void funnel(OFInstructionMeterVer13 message, PrimitiveSink sink) {
            sink.putShort((short)6);
            sink.putShort((short)8);
            sink.putLong(message.meterId);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionMeter> {
        Reader() {
        }

        @Override
        public OFInstructionMeter readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 6) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.METER(6), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long meterId = U32.f(bb.readInt());
            OFInstructionMeterVer13 instructionMeterVer13 = new OFInstructionMeterVer13(meterId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionMeterVer13);
            }
            return instructionMeterVer13;
        }
    }

    static class Builder
    implements OFInstructionMeter.Builder {
        private boolean meterIdSet;
        private long meterId;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.METER;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFInstructionMeter.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionMeter build() {
            long meterId = this.meterIdSet ? this.meterId : 0L;
            return new OFInstructionMeterVer13(meterId);
        }
    }

    static class BuilderWithParent
    implements OFInstructionMeter.Builder {
        final OFInstructionMeterVer13 parentMessage;
        private boolean meterIdSet;
        private long meterId;

        BuilderWithParent(OFInstructionMeterVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.METER;
        }

        @Override
        public long getMeterId() {
            return this.meterId;
        }

        @Override
        public OFInstructionMeter.Builder setMeterId(long meterId) {
            this.meterId = meterId;
            this.meterIdSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFInstructionMeter build() {
            long meterId = this.meterIdSet ? this.meterId : this.parentMessage.meterId;
            return new OFInstructionMeterVer13(meterId);
        }
    }
}

