/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnIpTunnelType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpTunnelType;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnIpTunnelTypeSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpTunnelTypeVer13
implements OFBsnTlvIpTunnelType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpTunnelTypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private final OFBsnIpTunnelType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvIpTunnelTypeVer13Funnel FUNNEL = new OFBsnTlvIpTunnelTypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpTunnelTypeVer13(OFBsnIpTunnelType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpTunnelTypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 169;
    }

    @Override
    public OFBsnIpTunnelType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvIpTunnelType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpTunnelTypeVer13(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpTunnelTypeVer13 other = (OFBsnTlvIpTunnelTypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpTunnelTypeVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpTunnelTypeVer13 message) {
            bb.writeShort(169);
            bb.writeShort(6);
            OFBsnIpTunnelTypeSerializerVer13.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvIpTunnelTypeVer13Funnel
    implements Funnel<OFBsnTlvIpTunnelTypeVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpTunnelTypeVer13Funnel() {
        }

        public void funnel(OFBsnTlvIpTunnelTypeVer13 message, PrimitiveSink sink) {
            sink.putShort((short)169);
            sink.putShort((short)6);
            OFBsnIpTunnelTypeSerializerVer13.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpTunnelType> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpTunnelType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 169) {
                throw new OFParseError("Wrong type: Expected=0xa9(0xa9), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnIpTunnelType value = OFBsnIpTunnelTypeSerializerVer13.readFrom(bb);
            OFBsnTlvIpTunnelTypeVer13 bsnTlvIpTunnelTypeVer13 = new OFBsnTlvIpTunnelTypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpTunnelTypeVer13);
            }
            return bsnTlvIpTunnelTypeVer13;
        }
    }

    static class Builder
    implements OFBsnTlvIpTunnelType.Builder {
        private boolean valueSet;
        private OFBsnIpTunnelType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 169;
        }

        @Override
        public OFBsnIpTunnelType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpTunnelType.Builder setValue(OFBsnIpTunnelType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpTunnelType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpTunnelTypeVer13(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpTunnelType.Builder {
        final OFBsnTlvIpTunnelTypeVer13 parentMessage;
        private boolean valueSet;
        private OFBsnIpTunnelType value;

        BuilderWithParent(OFBsnTlvIpTunnelTypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 169;
        }

        @Override
        public OFBsnIpTunnelType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpTunnelType.Builder setValue(OFBsnIpTunnelType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvIpTunnelType build() {
            OFBsnIpTunnelType value;
            OFBsnIpTunnelType oFBsnIpTunnelType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpTunnelTypeVer13(value);
        }
    }
}

