/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGentableEntryDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U128;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGentableEntryDescStatsRequestVer13
implements OFBsnGentableEntryDescStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableEntryDescStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 60;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final U128 DEFAULT_CHECKSUM = U128.ZERO;
    private static final U128 DEFAULT_CHECKSUM_MASK = U128.ZERO;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final GenTableId tableId;
    private final U128 checksum;
    private final U128 checksumMask;
    static final Reader READER = new Reader();
    static final OFBsnGentableEntryDescStatsRequestVer13Funnel FUNNEL = new OFBsnGentableEntryDescStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGentableEntryDescStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, GenTableId tableId, U128 checksum, U128 checksumMask) {
        if (flags == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsRequestVer13: property flags cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsRequestVer13: property tableId cannot be null");
        }
        if (checksum == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsRequestVer13: property checksum cannot be null");
        }
        if (checksumMask == null) {
            throw new NullPointerException("OFBsnGentableEntryDescStatsRequestVer13: property checksumMask cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.tableId = tableId;
        this.checksum = checksum;
        this.checksumMask = checksumMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 2L;
    }

    @Override
    public GenTableId getTableId() {
        return this.tableId;
    }

    @Override
    public U128 getChecksum() {
        return this.checksum;
    }

    @Override
    public U128 getChecksumMask() {
        return this.checksumMask;
    }

    @Override
    public OFBsnGentableEntryDescStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableEntryDescStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("checksum=").append(this.checksum);
        b.append(", ");
        b.append("checksumMask=").append(this.checksumMask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryDescStatsRequestVer13 other = (OFBsnGentableEntryDescStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        return !(this.checksumMask == null ? other.checksumMask != null : !this.checksumMask.equals(other.checksumMask));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGentableEntryDescStatsRequestVer13 other = (OFBsnGentableEntryDescStatsRequestVer13)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum)) {
            return false;
        }
        return !(this.checksumMask == null ? other.checksumMask != null : !this.checksumMask.equals(other.checksumMask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.checksumMask == null ? 0 : this.checksumMask.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        result = 31 * result + (this.checksumMask == null ? 0 : this.checksumMask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGentableEntryDescStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGentableEntryDescStatsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(18);
            bb.writeShort(60);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(2);
            message.tableId.write2Bytes(bb);
            bb.writeZero(2);
            message.checksum.write16Bytes(bb);
            message.checksumMask.write16Bytes(bb);
        }
    }

    static class OFBsnGentableEntryDescStatsRequestVer13Funnel
    implements Funnel<OFBsnGentableEntryDescStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnGentableEntryDescStatsRequestVer13Funnel() {
        }

        public void funnel(OFBsnGentableEntryDescStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putShort((short)60);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(2);
            message.tableId.putTo(sink);
            message.checksum.putTo(sink);
            message.checksumMask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGentableEntryDescStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 60) {
                throw new OFParseError("Wrong length: Expected=60(60), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 2) {
                throw new OFParseError("Wrong subtype: Expected=0x2L(0x2L), got=" + subtype);
            }
            GenTableId tableId = GenTableId.read2Bytes(bb);
            bb.skipBytes(2);
            U128 checksum = U128.read16Bytes(bb);
            U128 checksumMask = U128.read16Bytes(bb);
            OFBsnGentableEntryDescStatsRequestVer13 bsnGentableEntryDescStatsRequestVer13 = new OFBsnGentableEntryDescStatsRequestVer13(xid, flags, tableId, checksum, checksumMask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGentableEntryDescStatsRequestVer13);
            }
            return bsnGentableEntryDescStatsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnGentableEntryDescStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean checksumMaskSet;
        private U128 checksumMask;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public U128 getChecksumMask() {
            return this.checksumMask;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setChecksumMask(U128 checksumMask) {
            this.checksumMask = checksumMask;
            this.checksumMaskSet = true;
            return this;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest build() {
            U128 checksumMask;
            U128 checksum;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            if (!this.tableIdSet) {
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            }
            if (this.tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            U128 u1282 = checksumMask = this.checksumMaskSet ? this.checksumMask : DEFAULT_CHECKSUM_MASK;
            if (checksumMask == null) {
                throw new NullPointerException("Property checksumMask must not be null");
            }
            return new OFBsnGentableEntryDescStatsRequestVer13(xid, flags, this.tableId, checksum, checksumMask);
        }
    }

    static class BuilderWithParent
    implements OFBsnGentableEntryDescStatsRequest.Builder {
        final OFBsnGentableEntryDescStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean checksumSet;
        private U128 checksum;
        private boolean checksumMaskSet;
        private U128 checksumMask;

        BuilderWithParent(OFBsnGentableEntryDescStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 2L;
        }

        @Override
        public GenTableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setTableId(GenTableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U128 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setChecksum(U128 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public U128 getChecksumMask() {
            return this.checksumMask;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest.Builder setChecksumMask(U128 checksumMask) {
            this.checksumMask = checksumMask;
            this.checksumMaskSet = true;
            return this;
        }

        @Override
        public OFBsnGentableEntryDescStatsRequest build() {
            U128 checksumMask;
            U128 checksum;
            GenTableId tableId;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            GenTableId genTableId = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U128 u128 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            U128 u1282 = checksumMask = this.checksumMaskSet ? this.checksumMask : this.parentMessage.checksumMask;
            if (checksumMask == null) {
                throw new NullPointerException("Property checksumMask must not be null");
            }
            return new OFBsnGentableEntryDescStatsRequestVer13(xid, flags, tableId, checksum, checksumMask);
        }
    }
}

