/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowIdle;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.Match;
import org.projectfloodlight.openflow.protocol.ver13.ChannelUtilsVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowIdleVer13
implements OFBsnFlowIdle {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowIdleVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 40;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final U64 DEFAULT_COOKIE = U64.ZERO;
    private static final int DEFAULT_PRIORITY = 0;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final Match DEFAULT_MATCH = OFFactoryVer13.MATCH_WILDCARD_ALL;
    private final long xid;
    private final U64 cookie;
    private final int priority;
    private final TableId tableId;
    private final Match match;
    static final OFBsnFlowIdleVer13 DEFAULT = new OFBsnFlowIdleVer13(0L, DEFAULT_COOKIE, 0, DEFAULT_TABLE_ID, DEFAULT_MATCH);
    static final Reader READER = new Reader();
    static final OFBsnFlowIdleVer13Funnel FUNNEL = new OFBsnFlowIdleVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowIdleVer13(long xid, U64 cookie, int priority, TableId tableId, Match match) {
        if (cookie == null) {
            throw new NullPointerException("OFBsnFlowIdleVer13: property cookie cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFBsnFlowIdleVer13: property tableId cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFBsnFlowIdleVer13: property match cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.cookie = cookie;
        this.priority = U16.normalize(priority);
        this.tableId = tableId;
        this.match = match;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 40L;
    }

    @Override
    public U64 getCookie() {
        return this.cookie;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public OFBsnFlowIdle.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowIdleVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("cookie=").append(this.cookie);
        b.append(", ");
        b.append("priority=").append(this.priority);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleVer13 other = (OFBsnFlowIdleVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowIdleVer13 other = (OFBsnFlowIdleVer13)obj;
        if (this.cookie == null ? other.cookie != null : !this.cookie.equals(other.cookie)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cookie == null ? 0 : this.cookie.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowIdleVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnFlowIdleVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(4);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(40);
            bb.writeLong(message.cookie.getValue());
            bb.writeShort((int)U16.t(message.priority));
            message.tableId.writeByte(bb);
            bb.writeZero(5);
            message.match.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnFlowIdleVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnFlowIdleVer13Funnel
    implements Funnel<OFBsnFlowIdleVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowIdleVer13Funnel() {
        }

        public void funnel(OFBsnFlowIdleVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)4);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(40);
            message.cookie.putTo(sink);
            sink.putInt(message.priority);
            message.tableId.putTo(sink);
            message.match.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowIdle> {
        Reader() {
        }

        @Override
        public OFBsnFlowIdle readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 40) {
                throw new OFParseError("Wrong subtype: Expected=0x28L(0x28L), got=" + subtype);
            }
            U64 cookie = U64.ofRaw(bb.readLong());
            int priority = U16.f(bb.readShort());
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(5);
            Match match = ChannelUtilsVer13.readOFMatch(bb);
            OFBsnFlowIdleVer13 bsnFlowIdleVer13 = new OFBsnFlowIdleVer13(xid, cookie, priority, tableId, match);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowIdleVer13);
            }
            return bsnFlowIdleVer13;
        }
    }

    static class Builder
    implements OFBsnFlowIdle.Builder {
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean matchSet;
        private Match match;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdle.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 40L;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFBsnFlowIdle.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFBsnFlowIdle.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnFlowIdle.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFBsnFlowIdle.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdle build() {
            Match match;
            TableId tableId;
            U64 cookie;
            long xid = this.xidSet ? this.xid : 0L;
            U64 u64 = cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : 0;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : DEFAULT_MATCH;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFBsnFlowIdleVer13(xid, cookie, priority, tableId, match);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowIdle.Builder {
        final OFBsnFlowIdleVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean cookieSet;
        private U64 cookie;
        private boolean prioritySet;
        private int priority;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean matchSet;
        private Match match;

        BuilderWithParent(OFBsnFlowIdleVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowIdle.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 40L;
        }

        @Override
        public U64 getCookie() {
            return this.cookie;
        }

        @Override
        public OFBsnFlowIdle.Builder setCookie(U64 cookie) {
            this.cookie = cookie;
            this.cookieSet = true;
            return this;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public OFBsnFlowIdle.Builder setPriority(int priority) {
            this.priority = priority;
            this.prioritySet = true;
            return this;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnFlowIdle.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public Match getMatch() {
            return this.match;
        }

        @Override
        public OFBsnFlowIdle.Builder setMatch(Match match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public OFBsnFlowIdle build() {
            Match match;
            TableId tableId;
            U64 cookie;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            U64 u64 = cookie = this.cookieSet ? this.cookie : this.parentMessage.cookie;
            if (cookie == null) {
                throw new NullPointerException("Property cookie must not be null");
            }
            int priority = this.prioritySet ? this.priority : this.parentMessage.priority;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            Match match2 = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            return new OFBsnFlowIdleVer13(xid, cookie, priority, tableId, match);
        }
    }
}

