/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFBsnError;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnErrorVer13
implements OFBsnError {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnErrorVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 272;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final String DEFAULT_ERR_MSG = "";
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final String errMsg;
    private final OFErrorCauseData data;
    static final OFBsnErrorVer13 DEFAULT = new OFBsnErrorVer13(0L, "", DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFBsnErrorVer13Funnel FUNNEL = new OFBsnErrorVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnErrorVer13(long xid, String errMsg, OFErrorCauseData data) {
        if (errMsg == null) {
            throw new NullPointerException("OFBsnErrorVer13: property errMsg cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFBsnErrorVer13: property data cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.errMsg = errMsg;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return 1;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public String getErrMsg() {
        return this.errMsg;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFBsnError.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnErrorVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("errMsg=").append(this.errMsg);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnErrorVer13 other = (OFBsnErrorVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.errMsg == null ? other.errMsg != null : !this.errMsg.equals(other.errMsg)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnErrorVer13 other = (OFBsnErrorVer13)obj;
        if (this.errMsg == null ? other.errMsg != null : !this.errMsg.equals(other.errMsg)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.errMsg == null ? 0 : this.errMsg.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errMsg == null ? 0 : this.errMsg.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnErrorVer13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnErrorVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(4);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            bb.writeShort(1);
            bb.writeInt(6035143);
            ChannelUtils.writeFixedLengthString(bb, message.errMsg, 256);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnErrorVer13: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnErrorVer13Funnel
    implements Funnel<OFBsnErrorVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnErrorVer13Funnel() {
        }

        public void funnel(OFBsnErrorVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            sink.putShort((short)1);
            sink.putInt(6035143);
            sink.putUnencodedChars((CharSequence)message.errMsg);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnError> {
        Reader() {
        }

        @Override
        public OFBsnError readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 272) {
                throw new OFParseError("Wrong length: Expected to be >= 272, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != -1) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got=" + errType);
            }
            short subtype = bb.readShort();
            if (subtype != 1) {
                throw new OFParseError("Wrong subtype: Expected=0x1(0x1), got=" + subtype);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            String errMsg = ChannelUtils.readFixedLengthString(bb, 256);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_13);
            OFBsnErrorVer13 bsnErrorVer13 = new OFBsnErrorVer13(xid, errMsg, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnErrorVer13);
            }
            return bsnErrorVer13;
        }
    }

    static class Builder
    implements OFBsnError.Builder {
        private boolean xidSet;
        private long xid;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnError.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return 1;
        }

        @Override
        public OFBsnError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        @Override
        public OFBsnError.Builder setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            this.errMsgSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFBsnError.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnError build() {
            OFErrorCauseData data;
            String errMsg;
            long xid = this.xidSet ? this.xid : 0L;
            String string = errMsg = this.errMsgSet ? this.errMsg : OFBsnErrorVer13.DEFAULT_ERR_MSG;
            if (errMsg == null) {
                throw new NullPointerException("Property errMsg must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnErrorVer13(xid, errMsg, data);
        }
    }

    static class BuilderWithParent
    implements OFBsnError.Builder {
        final OFBsnErrorVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFBsnErrorVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnError.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.EXPERIMENTER;
        }

        @Override
        public int getSubtype() {
            return 1;
        }

        @Override
        public OFBsnError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public String getErrMsg() {
            return this.errMsg;
        }

        @Override
        public OFBsnError.Builder setErrMsg(String errMsg) {
            this.errMsg = errMsg;
            this.errMsgSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFBsnError.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFBsnError build() {
            OFErrorCauseData data;
            String errMsg;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            String string = errMsg = this.errMsgSet ? this.errMsg : this.parentMessage.errMsg;
            if (errMsg == null) {
                throw new NullPointerException("Property errMsg must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFBsnErrorVer13(xid, errMsg, data);
        }
    }
}

