/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMatchBmap;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableStatsEntry;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.ChannelUtilsVer12;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableStatsEntryVer12
implements OFTableStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFTableStatsEntryVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 128;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final String DEFAULT_NAME = "";
    private static final int DEFAULT_WILDCARDS = 0;
    private static final long DEFAULT_WRITE_ACTIONS = 0L;
    private static final long DEFAULT_APPLY_ACTIONS = 0L;
    private static final U64 DEFAULT_WRITE_SETFIELDS = U64.ZERO;
    private static final U64 DEFAULT_APPLY_SETFIELDS = U64.ZERO;
    private static final U64 DEFAULT_METADATA_MATCH = U64.ZERO;
    private static final U64 DEFAULT_METADATA_WRITE = U64.ZERO;
    private static final long DEFAULT_INSTRUCTIONS = 0L;
    private static final long DEFAULT_CONFIG = 0L;
    private static final long DEFAULT_MAX_ENTRIES = 0L;
    private static final long DEFAULT_ACTIVE_COUNT = 0L;
    private static final U64 DEFAULT_LOOKUP_COUNT = U64.ZERO;
    private static final U64 DEFAULT_MATCHED_COUNT = U64.ZERO;
    private final TableId tableId;
    private final String name;
    private final OFMatchBmap match;
    private final int wildcards;
    private final long writeActions;
    private final long applyActions;
    private final U64 writeSetfields;
    private final U64 applySetfields;
    private final U64 metadataMatch;
    private final U64 metadataWrite;
    private final long instructions;
    private final long config;
    private final long maxEntries;
    private final long activeCount;
    private final U64 lookupCount;
    private final U64 matchedCount;
    static final Reader READER = new Reader();
    static final OFTableStatsEntryVer12Funnel FUNNEL = new OFTableStatsEntryVer12Funnel();
    static final Writer WRITER = new Writer();

    OFTableStatsEntryVer12(TableId tableId, String name, OFMatchBmap match, int wildcards, long writeActions, long applyActions, U64 writeSetfields, U64 applySetfields, U64 metadataMatch, U64 metadataWrite, long instructions, long config, long maxEntries, long activeCount, U64 lookupCount, U64 matchedCount) {
        if (tableId == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property tableId cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property name cannot be null");
        }
        if (match == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property match cannot be null");
        }
        if (writeSetfields == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property writeSetfields cannot be null");
        }
        if (applySetfields == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property applySetfields cannot be null");
        }
        if (metadataMatch == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property metadataMatch cannot be null");
        }
        if (metadataWrite == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property metadataWrite cannot be null");
        }
        if (lookupCount == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property lookupCount cannot be null");
        }
        if (matchedCount == null) {
            throw new NullPointerException("OFTableStatsEntryVer12: property matchedCount cannot be null");
        }
        this.tableId = tableId;
        this.name = name;
        this.match = match;
        this.wildcards = wildcards;
        this.writeActions = U32.normalize(writeActions);
        this.applyActions = U32.normalize(applyActions);
        this.writeSetfields = writeSetfields;
        this.applySetfields = applySetfields;
        this.metadataMatch = metadataMatch;
        this.metadataWrite = metadataWrite;
        this.instructions = U32.normalize(instructions);
        this.config = U32.normalize(config);
        this.maxEntries = U32.normalize(maxEntries);
        this.activeCount = U32.normalize(activeCount);
        this.lookupCount = lookupCount;
        this.matchedCount = matchedCount;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public long getActiveCount() {
        return this.activeCount;
    }

    @Override
    public U64 getLookupCount() {
        return this.lookupCount;
    }

    @Override
    public U64 getMatchedCount() {
        return this.matchedCount;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWildcards() {
        return this.wildcards;
    }

    @Override
    public long getMaxEntries() {
        return this.maxEntries;
    }

    @Override
    public OFMatchBmap getMatch() {
        return this.match;
    }

    @Override
    public long getWriteActions() {
        return this.writeActions;
    }

    @Override
    public long getApplyActions() {
        return this.applyActions;
    }

    @Override
    public U64 getWriteSetfields() {
        return this.writeSetfields;
    }

    @Override
    public U64 getApplySetfields() {
        return this.applySetfields;
    }

    @Override
    public U64 getMetadataMatch() {
        return this.metadataMatch;
    }

    @Override
    public U64 getMetadataWrite() {
        return this.metadataWrite;
    }

    @Override
    public long getInstructions() {
        return this.instructions;
    }

    @Override
    public long getConfig() {
        return this.config;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFTableStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableStatsEntryVer12(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("match=").append(this.match);
        b.append(", ");
        b.append("wildcards=").append(this.wildcards);
        b.append(", ");
        b.append("writeActions=").append(this.writeActions);
        b.append(", ");
        b.append("applyActions=").append(this.applyActions);
        b.append(", ");
        b.append("writeSetfields=").append(this.writeSetfields);
        b.append(", ");
        b.append("applySetfields=").append(this.applySetfields);
        b.append(", ");
        b.append("metadataMatch=").append(this.metadataMatch);
        b.append(", ");
        b.append("metadataWrite=").append(this.metadataWrite);
        b.append(", ");
        b.append("instructions=").append(this.instructions);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("maxEntries=").append(this.maxEntries);
        b.append(", ");
        b.append("activeCount=").append(this.activeCount);
        b.append(", ");
        b.append("lookupCount=").append(this.lookupCount);
        b.append(", ");
        b.append("matchedCount=").append(this.matchedCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableStatsEntryVer12 other = (OFTableStatsEntryVer12)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.wildcards != other.wildcards) {
            return false;
        }
        if (this.writeActions != other.writeActions) {
            return false;
        }
        if (this.applyActions != other.applyActions) {
            return false;
        }
        if (this.writeSetfields == null ? other.writeSetfields != null : !this.writeSetfields.equals(other.writeSetfields)) {
            return false;
        }
        if (this.applySetfields == null ? other.applySetfields != null : !this.applySetfields.equals(other.applySetfields)) {
            return false;
        }
        if (this.metadataMatch == null ? other.metadataMatch != null : !this.metadataMatch.equals(other.metadataMatch)) {
            return false;
        }
        if (this.metadataWrite == null ? other.metadataWrite != null : !this.metadataWrite.equals(other.metadataWrite)) {
            return false;
        }
        if (this.instructions != other.instructions) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        if (this.activeCount != other.activeCount) {
            return false;
        }
        if (this.lookupCount == null ? other.lookupCount != null : !this.lookupCount.equals(other.lookupCount)) {
            return false;
        }
        return !(this.matchedCount == null ? other.matchedCount != null : !this.matchedCount.equals(other.matchedCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + this.wildcards;
        result = 31 * (int)(this.writeActions ^ this.writeActions >>> 32);
        result = 31 * (int)(this.applyActions ^ this.applyActions >>> 32);
        result = 31 * result + (this.writeSetfields == null ? 0 : this.writeSetfields.hashCode());
        result = 31 * result + (this.applySetfields == null ? 0 : this.applySetfields.hashCode());
        result = 31 * result + (this.metadataMatch == null ? 0 : this.metadataMatch.hashCode());
        result = 31 * result + (this.metadataWrite == null ? 0 : this.metadataWrite.hashCode());
        result = 31 * (int)(this.instructions ^ this.instructions >>> 32);
        result = 31 * (int)(this.config ^ this.config >>> 32);
        result = 31 * (int)(this.maxEntries ^ this.maxEntries >>> 32);
        result = 31 * (int)(this.activeCount ^ this.activeCount >>> 32);
        result = 31 * result + (this.lookupCount == null ? 0 : this.lookupCount.hashCode());
        result = 31 * result + (this.matchedCount == null ? 0 : this.matchedCount.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableStatsEntryVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableStatsEntryVer12 message) {
            message.tableId.writeByte(bb);
            bb.writeZero(7);
            ChannelUtils.writeFixedLengthString(bb, message.name, 32);
            ChannelUtilsVer12.writeOFMatchBmap(bb, message.match);
            bb.writeInt(message.wildcards);
            bb.writeInt(U32.t(message.writeActions));
            bb.writeInt(U32.t(message.applyActions));
            bb.writeLong(message.writeSetfields.getValue());
            bb.writeLong(message.applySetfields.getValue());
            bb.writeLong(message.metadataMatch.getValue());
            bb.writeLong(message.metadataWrite.getValue());
            bb.writeInt(U32.t(message.instructions));
            bb.writeInt(U32.t(message.config));
            bb.writeInt(U32.t(message.maxEntries));
            bb.writeInt(U32.t(message.activeCount));
            bb.writeLong(message.lookupCount.getValue());
            bb.writeLong(message.matchedCount.getValue());
        }
    }

    static class OFTableStatsEntryVer12Funnel
    implements Funnel<OFTableStatsEntryVer12> {
        private static final long serialVersionUID = 1L;

        OFTableStatsEntryVer12Funnel() {
        }

        public void funnel(OFTableStatsEntryVer12 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            message.match.putTo(sink);
            sink.putInt(message.wildcards);
            sink.putLong(message.writeActions);
            sink.putLong(message.applyActions);
            message.writeSetfields.putTo(sink);
            message.applySetfields.putTo(sink);
            message.metadataMatch.putTo(sink);
            message.metadataWrite.putTo(sink);
            sink.putLong(message.instructions);
            sink.putLong(message.config);
            sink.putLong(message.maxEntries);
            sink.putLong(message.activeCount);
            message.lookupCount.putTo(sink);
            message.matchedCount.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableStatsEntry> {
        Reader() {
        }

        @Override
        public OFTableStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            TableId tableId = TableId.readByte(bb);
            bb.skipBytes(7);
            String name = ChannelUtils.readFixedLengthString(bb, 32);
            OFMatchBmap match = ChannelUtilsVer12.readOFMatchBmap(bb);
            int wildcards = bb.readInt();
            long writeActions = U32.f(bb.readInt());
            long applyActions = U32.f(bb.readInt());
            U64 writeSetfields = U64.ofRaw(bb.readLong());
            U64 applySetfields = U64.ofRaw(bb.readLong());
            U64 metadataMatch = U64.ofRaw(bb.readLong());
            U64 metadataWrite = U64.ofRaw(bb.readLong());
            long instructions = U32.f(bb.readInt());
            long config = U32.f(bb.readInt());
            long maxEntries = U32.f(bb.readInt());
            long activeCount = U32.f(bb.readInt());
            U64 lookupCount = U64.ofRaw(bb.readLong());
            U64 matchedCount = U64.ofRaw(bb.readLong());
            OFTableStatsEntryVer12 tableStatsEntryVer12 = new OFTableStatsEntryVer12(tableId, name, match, wildcards, writeActions, applyActions, writeSetfields, applySetfields, metadataMatch, metadataWrite, instructions, config, maxEntries, activeCount, lookupCount, matchedCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableStatsEntryVer12);
            }
            return tableStatsEntryVer12;
        }
    }

    static class Builder
    implements OFTableStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean matchSet;
        private OFMatchBmap match;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean writeActionsSet;
        private long writeActions;
        private boolean applyActionsSet;
        private long applyActions;
        private boolean writeSetfieldsSet;
        private U64 writeSetfields;
        private boolean applySetfieldsSet;
        private U64 applySetfields;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean instructionsSet;
        private long instructions;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean activeCountSet;
        private long activeCount;
        private boolean lookupCountSet;
        private U64 lookupCount;
        private boolean matchedCountSet;
        private U64 matchedCount;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getActiveCount() {
            return this.activeCount;
        }

        @Override
        public OFTableStatsEntry.Builder setActiveCount(long activeCount) {
            this.activeCount = activeCount;
            this.activeCountSet = true;
            return this;
        }

        @Override
        public U64 getLookupCount() {
            return this.lookupCount;
        }

        @Override
        public OFTableStatsEntry.Builder setLookupCount(U64 lookupCount) {
            this.lookupCount = lookupCount;
            this.lookupCountSet = true;
            return this;
        }

        @Override
        public U64 getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public OFTableStatsEntry.Builder setMatchedCount(U64 matchedCount) {
            this.matchedCount = matchedCount;
            this.matchedCountSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFTableStatsEntry.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public OFMatchBmap getMatch() {
            return this.match;
        }

        @Override
        public OFTableStatsEntry.Builder setMatch(OFMatchBmap match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public long getWriteActions() {
            return this.writeActions;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteActions(long writeActions) {
            this.writeActions = writeActions;
            this.writeActionsSet = true;
            return this;
        }

        @Override
        public long getApplyActions() {
            return this.applyActions;
        }

        @Override
        public OFTableStatsEntry.Builder setApplyActions(long applyActions) {
            this.applyActions = applyActions;
            this.applyActionsSet = true;
            return this;
        }

        @Override
        public U64 getWriteSetfields() {
            return this.writeSetfields;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteSetfields(U64 writeSetfields) {
            this.writeSetfields = writeSetfields;
            this.writeSetfieldsSet = true;
            return this;
        }

        @Override
        public U64 getApplySetfields() {
            return this.applySetfields;
        }

        @Override
        public OFTableStatsEntry.Builder setApplySetfields(U64 applySetfields) {
            this.applySetfields = applySetfields;
            this.applySetfieldsSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getInstructions() {
            return this.instructions;
        }

        @Override
        public OFTableStatsEntry.Builder setInstructions(long instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFTableStatsEntry build() {
            U64 matchedCount;
            U64 lookupCount;
            U64 metadataWrite;
            U64 metadataMatch;
            U64 applySetfields;
            U64 writeSetfields;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : OFTableStatsEntryVer12.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            if (!this.matchSet) {
                throw new IllegalStateException("Property match doesn't have default value -- must be set");
            }
            if (this.match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            int wildcards = this.wildcardsSet ? this.wildcards : 0;
            long writeActions = this.writeActionsSet ? this.writeActions : 0L;
            long applyActions = this.applyActionsSet ? this.applyActions : 0L;
            U64 u64 = writeSetfields = this.writeSetfieldsSet ? this.writeSetfields : DEFAULT_WRITE_SETFIELDS;
            if (writeSetfields == null) {
                throw new NullPointerException("Property writeSetfields must not be null");
            }
            U64 u642 = applySetfields = this.applySetfieldsSet ? this.applySetfields : DEFAULT_APPLY_SETFIELDS;
            if (applySetfields == null) {
                throw new NullPointerException("Property applySetfields must not be null");
            }
            U64 u643 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : DEFAULT_METADATA_MATCH;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u644 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : DEFAULT_METADATA_WRITE;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            long instructions = this.instructionsSet ? this.instructions : 0L;
            long config = this.configSet ? this.config : 0L;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : 0L;
            long activeCount = this.activeCountSet ? this.activeCount : 0L;
            U64 u645 = lookupCount = this.lookupCountSet ? this.lookupCount : DEFAULT_LOOKUP_COUNT;
            if (lookupCount == null) {
                throw new NullPointerException("Property lookupCount must not be null");
            }
            U64 u646 = matchedCount = this.matchedCountSet ? this.matchedCount : DEFAULT_MATCHED_COUNT;
            if (matchedCount == null) {
                throw new NullPointerException("Property matchedCount must not be null");
            }
            return new OFTableStatsEntryVer12(tableId, name, this.match, wildcards, writeActions, applyActions, writeSetfields, applySetfields, metadataMatch, metadataWrite, instructions, config, maxEntries, activeCount, lookupCount, matchedCount);
        }
    }

    static class BuilderWithParent
    implements OFTableStatsEntry.Builder {
        final OFTableStatsEntryVer12 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean nameSet;
        private String name;
        private boolean matchSet;
        private OFMatchBmap match;
        private boolean wildcardsSet;
        private int wildcards;
        private boolean writeActionsSet;
        private long writeActions;
        private boolean applyActionsSet;
        private long applyActions;
        private boolean writeSetfieldsSet;
        private U64 writeSetfields;
        private boolean applySetfieldsSet;
        private U64 applySetfields;
        private boolean metadataMatchSet;
        private U64 metadataMatch;
        private boolean metadataWriteSet;
        private U64 metadataWrite;
        private boolean instructionsSet;
        private long instructions;
        private boolean configSet;
        private long config;
        private boolean maxEntriesSet;
        private long maxEntries;
        private boolean activeCountSet;
        private long activeCount;
        private boolean lookupCountSet;
        private U64 lookupCount;
        private boolean matchedCountSet;
        private U64 matchedCount;

        BuilderWithParent(OFTableStatsEntryVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFTableStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public long getActiveCount() {
            return this.activeCount;
        }

        @Override
        public OFTableStatsEntry.Builder setActiveCount(long activeCount) {
            this.activeCount = activeCount;
            this.activeCountSet = true;
            return this;
        }

        @Override
        public U64 getLookupCount() {
            return this.lookupCount;
        }

        @Override
        public OFTableStatsEntry.Builder setLookupCount(U64 lookupCount) {
            this.lookupCount = lookupCount;
            this.lookupCountSet = true;
            return this;
        }

        @Override
        public U64 getMatchedCount() {
            return this.matchedCount;
        }

        @Override
        public OFTableStatsEntry.Builder setMatchedCount(U64 matchedCount) {
            this.matchedCount = matchedCount;
            this.matchedCountSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFTableStatsEntry.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public int getWildcards() {
            return this.wildcards;
        }

        @Override
        public OFTableStatsEntry.Builder setWildcards(int wildcards) {
            this.wildcards = wildcards;
            this.wildcardsSet = true;
            return this;
        }

        @Override
        public long getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public OFTableStatsEntry.Builder setMaxEntries(long maxEntries) {
            this.maxEntries = maxEntries;
            this.maxEntriesSet = true;
            return this;
        }

        @Override
        public OFMatchBmap getMatch() {
            return this.match;
        }

        @Override
        public OFTableStatsEntry.Builder setMatch(OFMatchBmap match) {
            this.match = match;
            this.matchSet = true;
            return this;
        }

        @Override
        public long getWriteActions() {
            return this.writeActions;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteActions(long writeActions) {
            this.writeActions = writeActions;
            this.writeActionsSet = true;
            return this;
        }

        @Override
        public long getApplyActions() {
            return this.applyActions;
        }

        @Override
        public OFTableStatsEntry.Builder setApplyActions(long applyActions) {
            this.applyActions = applyActions;
            this.applyActionsSet = true;
            return this;
        }

        @Override
        public U64 getWriteSetfields() {
            return this.writeSetfields;
        }

        @Override
        public OFTableStatsEntry.Builder setWriteSetfields(U64 writeSetfields) {
            this.writeSetfields = writeSetfields;
            this.writeSetfieldsSet = true;
            return this;
        }

        @Override
        public U64 getApplySetfields() {
            return this.applySetfields;
        }

        @Override
        public OFTableStatsEntry.Builder setApplySetfields(U64 applySetfields) {
            this.applySetfields = applySetfields;
            this.applySetfieldsSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMatch() {
            return this.metadataMatch;
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataMatch(U64 metadataMatch) {
            this.metadataMatch = metadataMatch;
            this.metadataMatchSet = true;
            return this;
        }

        @Override
        public U64 getMetadataWrite() {
            return this.metadataWrite;
        }

        @Override
        public OFTableStatsEntry.Builder setMetadataWrite(U64 metadataWrite) {
            this.metadataWrite = metadataWrite;
            this.metadataWriteSet = true;
            return this;
        }

        @Override
        public long getInstructions() {
            return this.instructions;
        }

        @Override
        public OFTableStatsEntry.Builder setInstructions(long instructions) {
            this.instructions = instructions;
            this.instructionsSet = true;
            return this;
        }

        @Override
        public long getConfig() {
            return this.config;
        }

        @Override
        public OFTableStatsEntry.Builder setConfig(long config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFTableStatsEntry build() {
            U64 matchedCount;
            U64 lookupCount;
            U64 metadataWrite;
            U64 metadataMatch;
            U64 applySetfields;
            U64 writeSetfields;
            OFMatchBmap match;
            String name;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            OFMatchBmap oFMatchBmap = match = this.matchSet ? this.match : this.parentMessage.match;
            if (match == null) {
                throw new NullPointerException("Property match must not be null");
            }
            int wildcards = this.wildcardsSet ? this.wildcards : this.parentMessage.wildcards;
            long writeActions = this.writeActionsSet ? this.writeActions : this.parentMessage.writeActions;
            long applyActions = this.applyActionsSet ? this.applyActions : this.parentMessage.applyActions;
            U64 u64 = writeSetfields = this.writeSetfieldsSet ? this.writeSetfields : this.parentMessage.writeSetfields;
            if (writeSetfields == null) {
                throw new NullPointerException("Property writeSetfields must not be null");
            }
            U64 u642 = applySetfields = this.applySetfieldsSet ? this.applySetfields : this.parentMessage.applySetfields;
            if (applySetfields == null) {
                throw new NullPointerException("Property applySetfields must not be null");
            }
            U64 u643 = metadataMatch = this.metadataMatchSet ? this.metadataMatch : this.parentMessage.metadataMatch;
            if (metadataMatch == null) {
                throw new NullPointerException("Property metadataMatch must not be null");
            }
            U64 u644 = metadataWrite = this.metadataWriteSet ? this.metadataWrite : this.parentMessage.metadataWrite;
            if (metadataWrite == null) {
                throw new NullPointerException("Property metadataWrite must not be null");
            }
            long instructions = this.instructionsSet ? this.instructions : this.parentMessage.instructions;
            long config = this.configSet ? this.config : this.parentMessage.config;
            long maxEntries = this.maxEntriesSet ? this.maxEntries : this.parentMessage.maxEntries;
            long activeCount = this.activeCountSet ? this.activeCount : this.parentMessage.activeCount;
            U64 u645 = lookupCount = this.lookupCountSet ? this.lookupCount : this.parentMessage.lookupCount;
            if (lookupCount == null) {
                throw new NullPointerException("Property lookupCount must not be null");
            }
            U64 u646 = matchedCount = this.matchedCountSet ? this.matchedCount : this.parentMessage.matchedCount;
            if (matchedCount == null) {
                throw new NullPointerException("Property matchedCount must not be null");
            }
            return new OFTableStatsEntryVer12(tableId, name, match, wildcards, writeActions, applyActions, writeSetfields, applySetfields, metadataMatch, metadataWrite, instructions, config, maxEntries, activeCount, lookupCount, matchedCount);
        }
    }
}

