/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVportL2Gre;
import org.projectfloodlight.openflow.protocol.OFBsnVportL2GreFlags;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver12.OFBsnVportL2GreFlagsSerializerVer12;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVportL2GreVer12
implements OFBsnVportL2Gre {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVportL2GreVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 64;
    private static final Set<OFBsnVportL2GreFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final OFPort DEFAULT_LOOPBACK_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_LOCAL_MAC = MacAddress.NONE;
    private static final MacAddress DEFAULT_NH_MAC = MacAddress.NONE;
    private static final IPv4Address DEFAULT_SRC_IP = IPv4Address.NONE;
    private static final IPv4Address DEFAULT_DST_IP = IPv4Address.NONE;
    private static final short DEFAULT_DSCP = 0;
    private static final short DEFAULT_TTL = 0;
    private static final long DEFAULT_VPN = 0L;
    private static final long DEFAULT_RATE_LIMIT = 0L;
    private static final String DEFAULT_IF_NAME = "";
    private final Set<OFBsnVportL2GreFlags> flags;
    private final OFPort portNo;
    private final OFPort loopbackPortNo;
    private final MacAddress localMac;
    private final MacAddress nhMac;
    private final IPv4Address srcIp;
    private final IPv4Address dstIp;
    private final short dscp;
    private final short ttl;
    private final long vpn;
    private final long rateLimit;
    private final String ifName;
    static final OFBsnVportL2GreVer12 DEFAULT = new OFBsnVportL2GreVer12(DEFAULT_FLAGS, DEFAULT_PORT_NO, DEFAULT_LOOPBACK_PORT_NO, DEFAULT_LOCAL_MAC, DEFAULT_NH_MAC, DEFAULT_SRC_IP, DEFAULT_DST_IP, 0, 0, 0L, 0L, "");
    static final Reader READER = new Reader();
    static final OFBsnVportL2GreVer12Funnel FUNNEL = new OFBsnVportL2GreVer12Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVportL2GreVer12(Set<OFBsnVportL2GreFlags> flags, OFPort portNo, OFPort loopbackPortNo, MacAddress localMac, MacAddress nhMac, IPv4Address srcIp, IPv4Address dstIp, short dscp, short ttl, long vpn, long rateLimit, String ifName) {
        if (flags == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property flags cannot be null");
        }
        if (portNo == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property portNo cannot be null");
        }
        if (loopbackPortNo == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property loopbackPortNo cannot be null");
        }
        if (localMac == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property localMac cannot be null");
        }
        if (nhMac == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property nhMac cannot be null");
        }
        if (srcIp == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property srcIp cannot be null");
        }
        if (dstIp == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property dstIp cannot be null");
        }
        if (ifName == null) {
            throw new NullPointerException("OFBsnVportL2GreVer12: property ifName cannot be null");
        }
        this.flags = flags;
        this.portNo = portNo;
        this.loopbackPortNo = loopbackPortNo;
        this.localMac = localMac;
        this.nhMac = nhMac;
        this.srcIp = srcIp;
        this.dstIp = dstIp;
        this.dscp = U8.normalize(dscp);
        this.ttl = U8.normalize(ttl);
        this.vpn = U32.normalize(vpn);
        this.rateLimit = U32.normalize(rateLimit);
        this.ifName = ifName;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Set<OFBsnVportL2GreFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public OFPort getLoopbackPortNo() {
        return this.loopbackPortNo;
    }

    @Override
    public MacAddress getLocalMac() {
        return this.localMac;
    }

    @Override
    public MacAddress getNhMac() {
        return this.nhMac;
    }

    @Override
    public IPv4Address getSrcIp() {
        return this.srcIp;
    }

    @Override
    public IPv4Address getDstIp() {
        return this.dstIp;
    }

    @Override
    public short getDscp() {
        return this.dscp;
    }

    @Override
    public short getTtl() {
        return this.ttl;
    }

    @Override
    public long getVpn() {
        return this.vpn;
    }

    @Override
    public long getRateLimit() {
        return this.rateLimit;
    }

    @Override
    public String getIfName() {
        return this.ifName;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFBsnVportL2Gre.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVportL2GreVer12(");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("loopbackPortNo=").append(this.loopbackPortNo);
        b.append(", ");
        b.append("localMac=").append(this.localMac);
        b.append(", ");
        b.append("nhMac=").append(this.nhMac);
        b.append(", ");
        b.append("srcIp=").append(this.srcIp);
        b.append(", ");
        b.append("dstIp=").append(this.dstIp);
        b.append(", ");
        b.append("dscp=").append(this.dscp);
        b.append(", ");
        b.append("ttl=").append(this.ttl);
        b.append(", ");
        b.append("vpn=").append(this.vpn);
        b.append(", ");
        b.append("rateLimit=").append(this.rateLimit);
        b.append(", ");
        b.append("ifName=").append(this.ifName);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVportL2GreVer12 other = (OFBsnVportL2GreVer12)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.loopbackPortNo == null ? other.loopbackPortNo != null : !this.loopbackPortNo.equals(other.loopbackPortNo)) {
            return false;
        }
        if (this.localMac == null ? other.localMac != null : !this.localMac.equals(other.localMac)) {
            return false;
        }
        if (this.nhMac == null ? other.nhMac != null : !this.nhMac.equals(other.nhMac)) {
            return false;
        }
        if (this.srcIp == null ? other.srcIp != null : !this.srcIp.equals(other.srcIp)) {
            return false;
        }
        if (this.dstIp == null ? other.dstIp != null : !this.dstIp.equals(other.dstIp)) {
            return false;
        }
        if (this.dscp != other.dscp) {
            return false;
        }
        if (this.ttl != other.ttl) {
            return false;
        }
        if (this.vpn != other.vpn) {
            return false;
        }
        if (this.rateLimit != other.rateLimit) {
            return false;
        }
        return !(this.ifName == null ? other.ifName != null : !this.ifName.equals(other.ifName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.loopbackPortNo == null ? 0 : this.loopbackPortNo.hashCode());
        result = 31 * result + (this.localMac == null ? 0 : this.localMac.hashCode());
        result = 31 * result + (this.nhMac == null ? 0 : this.nhMac.hashCode());
        result = 31 * result + (this.srcIp == null ? 0 : this.srcIp.hashCode());
        result = 31 * result + (this.dstIp == null ? 0 : this.dstIp.hashCode());
        result = 31 * result + this.dscp;
        result = 31 * result + this.ttl;
        result = 31 * (int)(this.vpn ^ this.vpn >>> 32);
        result = 31 * (int)(this.rateLimit ^ this.rateLimit >>> 32);
        result = 31 * result + (this.ifName == null ? 0 : this.ifName.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVportL2GreVer12> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnVportL2GreVer12 message) {
            bb.writeShort(1);
            bb.writeShort(64);
            OFBsnVportL2GreFlagsSerializerVer12.writeTo(bb, message.flags);
            message.portNo.write4Bytes(bb);
            message.loopbackPortNo.write4Bytes(bb);
            message.localMac.write6Bytes(bb);
            message.nhMac.write6Bytes(bb);
            message.srcIp.write4Bytes(bb);
            message.dstIp.write4Bytes(bb);
            bb.writeByte((int)U8.t(message.dscp));
            bb.writeByte((int)U8.t(message.ttl));
            bb.writeZero(2);
            bb.writeInt(U32.t(message.vpn));
            bb.writeInt(U32.t(message.rateLimit));
            ChannelUtils.writeFixedLengthString(bb, message.ifName, 16);
        }
    }

    static class OFBsnVportL2GreVer12Funnel
    implements Funnel<OFBsnVportL2GreVer12> {
        private static final long serialVersionUID = 1L;

        OFBsnVportL2GreVer12Funnel() {
        }

        public void funnel(OFBsnVportL2GreVer12 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)64);
            OFBsnVportL2GreFlagsSerializerVer12.putTo(message.flags, sink);
            message.portNo.putTo(sink);
            message.loopbackPortNo.putTo(sink);
            message.localMac.putTo(sink);
            message.nhMac.putTo(sink);
            message.srcIp.putTo(sink);
            message.dstIp.putTo(sink);
            sink.putShort(message.dscp);
            sink.putShort(message.ttl);
            sink.putLong(message.vpn);
            sink.putLong(message.rateLimit);
            sink.putUnencodedChars((CharSequence)message.ifName);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVportL2Gre> {
        Reader() {
        }

        @Override
        public OFBsnVportL2Gre readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 64) {
                throw new OFParseError("Wrong length: Expected=64(64), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnVportL2GreFlags> flags = OFBsnVportL2GreFlagsSerializerVer12.readFrom(bb);
            OFPort portNo = OFPort.read4Bytes(bb);
            OFPort loopbackPortNo = OFPort.read4Bytes(bb);
            MacAddress localMac = MacAddress.read6Bytes(bb);
            MacAddress nhMac = MacAddress.read6Bytes(bb);
            IPv4Address srcIp = IPv4Address.read4Bytes(bb);
            IPv4Address dstIp = IPv4Address.read4Bytes(bb);
            short dscp = U8.f(bb.readByte());
            short ttl = U8.f(bb.readByte());
            bb.skipBytes(2);
            long vpn = U32.f(bb.readInt());
            long rateLimit = U32.f(bb.readInt());
            String ifName = ChannelUtils.readFixedLengthString(bb, 16);
            OFBsnVportL2GreVer12 bsnVportL2GreVer12 = new OFBsnVportL2GreVer12(flags, portNo, loopbackPortNo, localMac, nhMac, srcIp, dstIp, dscp, ttl, vpn, rateLimit, ifName);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVportL2GreVer12);
            }
            return bsnVportL2GreVer12;
        }
    }

    static class Builder
    implements OFBsnVportL2Gre.Builder {
        private boolean flagsSet;
        private Set<OFBsnVportL2GreFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean loopbackPortNoSet;
        private OFPort loopbackPortNo;
        private boolean localMacSet;
        private MacAddress localMac;
        private boolean nhMacSet;
        private MacAddress nhMac;
        private boolean srcIpSet;
        private IPv4Address srcIp;
        private boolean dstIpSet;
        private IPv4Address dstIp;
        private boolean dscpSet;
        private short dscp;
        private boolean ttlSet;
        private short ttl;
        private boolean vpnSet;
        private long vpn;
        private boolean rateLimitSet;
        private long rateLimit;
        private boolean ifNameSet;
        private String ifName;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Set<OFBsnVportL2GreFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVportL2Gre.Builder setFlags(Set<OFBsnVportL2GreFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnVportL2Gre.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPort getLoopbackPortNo() {
            return this.loopbackPortNo;
        }

        @Override
        public OFBsnVportL2Gre.Builder setLoopbackPortNo(OFPort loopbackPortNo) {
            this.loopbackPortNo = loopbackPortNo;
            this.loopbackPortNoSet = true;
            return this;
        }

        @Override
        public MacAddress getLocalMac() {
            return this.localMac;
        }

        @Override
        public OFBsnVportL2Gre.Builder setLocalMac(MacAddress localMac) {
            this.localMac = localMac;
            this.localMacSet = true;
            return this;
        }

        @Override
        public MacAddress getNhMac() {
            return this.nhMac;
        }

        @Override
        public OFBsnVportL2Gre.Builder setNhMac(MacAddress nhMac) {
            this.nhMac = nhMac;
            this.nhMacSet = true;
            return this;
        }

        @Override
        public IPv4Address getSrcIp() {
            return this.srcIp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setSrcIp(IPv4Address srcIp) {
            this.srcIp = srcIp;
            this.srcIpSet = true;
            return this;
        }

        @Override
        public IPv4Address getDstIp() {
            return this.dstIp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setDstIp(IPv4Address dstIp) {
            this.dstIp = dstIp;
            this.dstIpSet = true;
            return this;
        }

        @Override
        public short getDscp() {
            return this.dscp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setDscp(short dscp) {
            this.dscp = dscp;
            this.dscpSet = true;
            return this;
        }

        @Override
        public short getTtl() {
            return this.ttl;
        }

        @Override
        public OFBsnVportL2Gre.Builder setTtl(short ttl) {
            this.ttl = ttl;
            this.ttlSet = true;
            return this;
        }

        @Override
        public long getVpn() {
            return this.vpn;
        }

        @Override
        public OFBsnVportL2Gre.Builder setVpn(long vpn) {
            this.vpn = vpn;
            this.vpnSet = true;
            return this;
        }

        @Override
        public long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public OFBsnVportL2Gre.Builder setRateLimit(long rateLimit) {
            this.rateLimit = rateLimit;
            this.rateLimitSet = true;
            return this;
        }

        @Override
        public String getIfName() {
            return this.ifName;
        }

        @Override
        public OFBsnVportL2Gre.Builder setIfName(String ifName) {
            this.ifName = ifName;
            this.ifNameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFBsnVportL2Gre build() {
            String ifName;
            IPv4Address dstIp;
            IPv4Address srcIp;
            MacAddress nhMac;
            MacAddress localMac;
            OFPort loopbackPortNo;
            OFPort portNo;
            Set<OFBsnVportL2GreFlags> flags;
            Set<OFBsnVportL2GreFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            OFPort oFPort2 = loopbackPortNo = this.loopbackPortNoSet ? this.loopbackPortNo : DEFAULT_LOOPBACK_PORT_NO;
            if (loopbackPortNo == null) {
                throw new NullPointerException("Property loopbackPortNo must not be null");
            }
            MacAddress macAddress = localMac = this.localMacSet ? this.localMac : DEFAULT_LOCAL_MAC;
            if (localMac == null) {
                throw new NullPointerException("Property localMac must not be null");
            }
            MacAddress macAddress2 = nhMac = this.nhMacSet ? this.nhMac : DEFAULT_NH_MAC;
            if (nhMac == null) {
                throw new NullPointerException("Property nhMac must not be null");
            }
            IPv4Address iPv4Address = srcIp = this.srcIpSet ? this.srcIp : DEFAULT_SRC_IP;
            if (srcIp == null) {
                throw new NullPointerException("Property srcIp must not be null");
            }
            IPv4Address iPv4Address2 = dstIp = this.dstIpSet ? this.dstIp : DEFAULT_DST_IP;
            if (dstIp == null) {
                throw new NullPointerException("Property dstIp must not be null");
            }
            short dscp = this.dscpSet ? this.dscp : (short)0;
            short ttl = this.ttlSet ? this.ttl : (short)0;
            long vpn = this.vpnSet ? this.vpn : 0L;
            long rateLimit = this.rateLimitSet ? this.rateLimit : 0L;
            String string = ifName = this.ifNameSet ? this.ifName : OFBsnVportL2GreVer12.DEFAULT_IF_NAME;
            if (ifName == null) {
                throw new NullPointerException("Property ifName must not be null");
            }
            return new OFBsnVportL2GreVer12(flags, portNo, loopbackPortNo, localMac, nhMac, srcIp, dstIp, dscp, ttl, vpn, rateLimit, ifName);
        }
    }

    static class BuilderWithParent
    implements OFBsnVportL2Gre.Builder {
        final OFBsnVportL2GreVer12 parentMessage;
        private boolean flagsSet;
        private Set<OFBsnVportL2GreFlags> flags;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean loopbackPortNoSet;
        private OFPort loopbackPortNo;
        private boolean localMacSet;
        private MacAddress localMac;
        private boolean nhMacSet;
        private MacAddress nhMac;
        private boolean srcIpSet;
        private IPv4Address srcIp;
        private boolean dstIpSet;
        private IPv4Address dstIp;
        private boolean dscpSet;
        private short dscp;
        private boolean ttlSet;
        private short ttl;
        private boolean vpnSet;
        private long vpn;
        private boolean rateLimitSet;
        private long rateLimit;
        private boolean ifNameSet;
        private String ifName;

        BuilderWithParent(OFBsnVportL2GreVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public Set<OFBsnVportL2GreFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVportL2Gre.Builder setFlags(Set<OFBsnVportL2GreFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnVportL2Gre.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFPort getLoopbackPortNo() {
            return this.loopbackPortNo;
        }

        @Override
        public OFBsnVportL2Gre.Builder setLoopbackPortNo(OFPort loopbackPortNo) {
            this.loopbackPortNo = loopbackPortNo;
            this.loopbackPortNoSet = true;
            return this;
        }

        @Override
        public MacAddress getLocalMac() {
            return this.localMac;
        }

        @Override
        public OFBsnVportL2Gre.Builder setLocalMac(MacAddress localMac) {
            this.localMac = localMac;
            this.localMacSet = true;
            return this;
        }

        @Override
        public MacAddress getNhMac() {
            return this.nhMac;
        }

        @Override
        public OFBsnVportL2Gre.Builder setNhMac(MacAddress nhMac) {
            this.nhMac = nhMac;
            this.nhMacSet = true;
            return this;
        }

        @Override
        public IPv4Address getSrcIp() {
            return this.srcIp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setSrcIp(IPv4Address srcIp) {
            this.srcIp = srcIp;
            this.srcIpSet = true;
            return this;
        }

        @Override
        public IPv4Address getDstIp() {
            return this.dstIp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setDstIp(IPv4Address dstIp) {
            this.dstIp = dstIp;
            this.dstIpSet = true;
            return this;
        }

        @Override
        public short getDscp() {
            return this.dscp;
        }

        @Override
        public OFBsnVportL2Gre.Builder setDscp(short dscp) {
            this.dscp = dscp;
            this.dscpSet = true;
            return this;
        }

        @Override
        public short getTtl() {
            return this.ttl;
        }

        @Override
        public OFBsnVportL2Gre.Builder setTtl(short ttl) {
            this.ttl = ttl;
            this.ttlSet = true;
            return this;
        }

        @Override
        public long getVpn() {
            return this.vpn;
        }

        @Override
        public OFBsnVportL2Gre.Builder setVpn(long vpn) {
            this.vpn = vpn;
            this.vpnSet = true;
            return this;
        }

        @Override
        public long getRateLimit() {
            return this.rateLimit;
        }

        @Override
        public OFBsnVportL2Gre.Builder setRateLimit(long rateLimit) {
            this.rateLimit = rateLimit;
            this.rateLimitSet = true;
            return this;
        }

        @Override
        public String getIfName() {
            return this.ifName;
        }

        @Override
        public OFBsnVportL2Gre.Builder setIfName(String ifName) {
            this.ifName = ifName;
            this.ifNameSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFBsnVportL2Gre build() {
            String ifName;
            IPv4Address dstIp;
            IPv4Address srcIp;
            MacAddress nhMac;
            MacAddress localMac;
            OFPort loopbackPortNo;
            OFPort portNo;
            Set flags;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            OFPort oFPort2 = loopbackPortNo = this.loopbackPortNoSet ? this.loopbackPortNo : this.parentMessage.loopbackPortNo;
            if (loopbackPortNo == null) {
                throw new NullPointerException("Property loopbackPortNo must not be null");
            }
            MacAddress macAddress = localMac = this.localMacSet ? this.localMac : this.parentMessage.localMac;
            if (localMac == null) {
                throw new NullPointerException("Property localMac must not be null");
            }
            MacAddress macAddress2 = nhMac = this.nhMacSet ? this.nhMac : this.parentMessage.nhMac;
            if (nhMac == null) {
                throw new NullPointerException("Property nhMac must not be null");
            }
            IPv4Address iPv4Address = srcIp = this.srcIpSet ? this.srcIp : this.parentMessage.srcIp;
            if (srcIp == null) {
                throw new NullPointerException("Property srcIp must not be null");
            }
            IPv4Address iPv4Address2 = dstIp = this.dstIpSet ? this.dstIp : this.parentMessage.dstIp;
            if (dstIp == null) {
                throw new NullPointerException("Property dstIp must not be null");
            }
            short dscp = this.dscpSet ? this.dscp : this.parentMessage.dscp;
            short ttl = this.ttlSet ? this.ttl : this.parentMessage.ttl;
            long vpn = this.vpnSet ? this.vpn : this.parentMessage.vpn;
            long rateLimit = this.rateLimitSet ? this.rateLimit : this.parentMessage.rateLimit;
            String string = ifName = this.ifNameSet ? this.ifName : this.parentMessage.ifName;
            if (ifName == null) {
                throw new NullPointerException("Property ifName must not be null");
            }
            return new OFBsnVportL2GreVer12(flags, portNo, loopbackPortNo, localMac, nhMac, srcIp, dstIp, dscp, ttl, vpn, rateLimit, ifName);
        }
    }
}

