/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFDescStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver11.OFStatsRequestFlagsSerializerVer11;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFDescStatsRequestVer11
implements OFDescStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFDescStatsRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 16;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    static final OFDescStatsRequestVer11 DEFAULT = new OFDescStatsRequestVer11(0L, DEFAULT_FLAGS);
    static final Reader READER = new Reader();
    static final OFDescStatsRequestVer11Funnel FUNNEL = new OFDescStatsRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFDescStatsRequestVer11(long xid, Set<OFStatsRequestFlags> flags) {
        if (flags == null) {
            throw new NullPointerException("OFDescStatsRequestVer11: property flags cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.DESC;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public OFDescStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFDescStatsRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFDescStatsRequestVer11 other = (OFDescStatsRequestVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFDescStatsRequestVer11 other = (OFDescStatsRequestVer11)obj;
        return !(this.flags == null ? other.flags != null : !this.flags.equals(other.flags));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFDescStatsRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFDescStatsRequestVer11 message) {
            bb.writeByte(2);
            bb.writeByte(18);
            bb.writeShort(16);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(0);
            OFStatsRequestFlagsSerializerVer11.writeTo(bb, message.flags);
            bb.writeZero(4);
        }
    }

    static class OFDescStatsRequestVer11Funnel
    implements Funnel<OFDescStatsRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFDescStatsRequestVer11Funnel() {
        }

        public void funnel(OFDescStatsRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)18);
            sink.putShort((short)16);
            sink.putLong(message.xid);
            sink.putShort((short)0);
            OFStatsRequestFlagsSerializerVer11.putTo(message.flags, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFDescStatsRequest> {
        Reader() {
        }

        @Override
        public OFDescStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 0) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.DESC(0), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer11.readFrom(bb);
            bb.skipBytes(4);
            OFDescStatsRequestVer11 descStatsRequestVer11 = new OFDescStatsRequestVer11(xid, flags);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)descStatsRequestVer11);
            }
            return descStatsRequestVer11;
        }
    }

    static class Builder
    implements OFDescStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFDescStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFDescStatsRequestVer11(xid, flags);
        }
    }

    static class BuilderWithParent
    implements OFDescStatsRequest.Builder {
        final OFDescStatsRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;

        BuilderWithParent(OFDescStatsRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFDescStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.DESC;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFDescStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public OFDescStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            return new OFDescStatsRequestVer11(xid, flags);
        }
    }
}

