/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBadInstructionCode;

public class OFBadInstructionCodeSerializerVer11 {
    public static final short UNKNOWN_INST_VAL = 0;
    public static final short UNSUP_INST_VAL = 1;
    public static final short BAD_TABLE_ID_VAL = 2;
    public static final short UNSUP_METADATA_VAL = 3;
    public static final short UNSUP_METADATA_MASK_VAL = 4;
    public static final short UNSUP_EXP_INST_VAL = 5;

    public static OFBadInstructionCode readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBadInstructionCodeSerializerVer11.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFBadInstructionCode e) {
        bb.writeShort((int)OFBadInstructionCodeSerializerVer11.toWireValue(e));
    }

    public static void putTo(OFBadInstructionCode e, PrimitiveSink sink) {
        sink.putShort(OFBadInstructionCodeSerializerVer11.toWireValue(e));
    }

    public static OFBadInstructionCode ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFBadInstructionCode.UNKNOWN_INST;
            }
            case 1: {
                return OFBadInstructionCode.UNSUP_INST;
            }
            case 2: {
                return OFBadInstructionCode.BAD_TABLE_ID;
            }
            case 3: {
                return OFBadInstructionCode.UNSUP_METADATA;
            }
            case 4: {
                return OFBadInstructionCode.UNSUP_METADATA_MASK;
            }
            case 5: {
                return OFBadInstructionCode.UNSUP_EXP_INST;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFBadInstructionCode in version 1.1: " + val);
    }

    public static short toWireValue(OFBadInstructionCode e) {
        switch (e) {
            case UNKNOWN_INST: {
                return 0;
            }
            case UNSUP_INST: {
                return 1;
            }
            case BAD_TABLE_ID: {
                return 2;
            }
            case UNSUP_METADATA: {
                return 3;
            }
            case UNSUP_METADATA_MASK: {
                return 4;
            }
            case UNSUP_EXP_INST: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFBadInstructionCode in version 1.1: " + (Object)((Object)e));
    }
}

