/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver10.OFAggregateStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFDescStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFExperimenterStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFQueueStatsRequestVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFTableStatsRequestVer10;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer10 {
    static final byte WIRE_VERSION = 1;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFStatsRequestVer10() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 1) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_10(1), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 16) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer10.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer10.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer10.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer10.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer10.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer10.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer10.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer10: " + statsType);
        }
    }
}

