/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetDlDst;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetDlDstVer10
implements OFActionSetDlDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetDlDstVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_DL_ADDR = MacAddress.NONE;
    private final MacAddress dlAddr;
    static final OFActionSetDlDstVer10 DEFAULT = new OFActionSetDlDstVer10(DEFAULT_DL_ADDR);
    static final Reader READER = new Reader();
    static final OFActionSetDlDstVer10Funnel FUNNEL = new OFActionSetDlDstVer10Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetDlDstVer10(MacAddress dlAddr) {
        if (dlAddr == null) {
            throw new NullPointerException("OFActionSetDlDstVer10: property dlAddr cannot be null");
        }
        this.dlAddr = dlAddr;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_DL_DST;
    }

    @Override
    public MacAddress getDlAddr() {
        return this.dlAddr;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public OFActionSetDlDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetDlDstVer10(");
        b.append("dlAddr=").append(this.dlAddr);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetDlDstVer10 other = (OFActionSetDlDstVer10)obj;
        return !(this.dlAddr == null ? other.dlAddr != null : !this.dlAddr.equals(other.dlAddr));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dlAddr == null ? 0 : this.dlAddr.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetDlDstVer10> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionSetDlDstVer10 message) {
            bb.writeShort(5);
            bb.writeShort(16);
            message.dlAddr.write6Bytes(bb);
            bb.writeZero(6);
        }
    }

    static class OFActionSetDlDstVer10Funnel
    implements Funnel<OFActionSetDlDstVer10> {
        private static final long serialVersionUID = 1L;

        OFActionSetDlDstVer10Funnel() {
        }

        public void funnel(OFActionSetDlDstVer10 message, PrimitiveSink sink) {
            sink.putShort((short)5);
            sink.putShort((short)16);
            message.dlAddr.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetDlDst> {
        Reader() {
        }

        @Override
        public OFActionSetDlDst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_DL_DST(5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress dlAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(6);
            OFActionSetDlDstVer10 actionSetDlDstVer10 = new OFActionSetDlDstVer10(dlAddr);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetDlDstVer10);
            }
            return actionSetDlDstVer10;
        }
    }

    static class Builder
    implements OFActionSetDlDst.Builder {
        private boolean dlAddrSet;
        private MacAddress dlAddr;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_DL_DST;
        }

        @Override
        public MacAddress getDlAddr() {
            return this.dlAddr;
        }

        @Override
        public OFActionSetDlDst.Builder setDlAddr(MacAddress dlAddr) {
            this.dlAddr = dlAddr;
            this.dlAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetDlDst build() {
            MacAddress dlAddr;
            MacAddress macAddress = dlAddr = this.dlAddrSet ? this.dlAddr : DEFAULT_DL_ADDR;
            if (dlAddr == null) {
                throw new NullPointerException("Property dlAddr must not be null");
            }
            return new OFActionSetDlDstVer10(dlAddr);
        }
    }

    static class BuilderWithParent
    implements OFActionSetDlDst.Builder {
        final OFActionSetDlDstVer10 parentMessage;
        private boolean dlAddrSet;
        private MacAddress dlAddr;

        BuilderWithParent(OFActionSetDlDstVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_DL_DST;
        }

        @Override
        public MacAddress getDlAddr() {
            return this.dlAddr;
        }

        @Override
        public OFActionSetDlDst.Builder setDlAddr(MacAddress dlAddr) {
            this.dlAddr = dlAddr;
            this.dlAddrSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFActionSetDlDst build() {
            MacAddress dlAddr;
            MacAddress macAddress = dlAddr = this.dlAddrSet ? this.dlAddr : this.parentMessage.dlAddr;
            if (dlAddr == null) {
                throw new NullPointerException("Property dlAddr must not be null");
            }
            return new OFActionSetDlDstVer10(dlAddr);
        }
    }
}

