/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.util.HexString;

public class HexStringTest {
    @Test
    public void testMarshalling() throws Exception {
        String dpidStr = "00:00:00:23:20:2d:16:71";
        long dpid = HexString.toLong((String)dpidStr);
        String testStr = HexString.toHexString((long)dpid);
        Assert.assertEquals((Object)dpidStr, (Object)testStr);
    }

    @Test
    public void testToLong() {
        String dpidStr = "3e:1f:01:fc:72:8c:63:31";
        long valid = 4476298738394751793L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((String)("was: " + Long.toHexString(testLong)), (long)valid, (long)testLong);
    }

    @Test
    public void testToLong2() {
        String dpidStr = "1f:1:fc:72:3:f:31";
        long valid = 8727908034219825L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((String)("was: " + Long.toHexString(testLong)), (long)valid, (long)testLong);
    }

    @Test
    public void testToLongMSB() {
        String dpidStr = "ca:7c:5e:d1:64:7a:95:9b";
        long valid = -3856102927509056101L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((long)valid, (long)testLong);
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorTooManyBytes() {
        HexString.toLong((String)"09:08:07:06:05:04:03:02:01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorByteValueTooLong() {
        HexString.toLong((String)"234:01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorEmptyByte() {
        HexString.toLong((String)"03::01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorColonAtEnd() {
        HexString.toLong((String)"03:01:");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorInvalidHexDigit() {
        HexString.toLong((String)"ss:01");
    }

    public void testToLongErrorEmptyString() {
        Assert.assertThat((Object)HexString.toLong((String)""), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void testToStringBytes() {
        byte[] dpid = new byte[]{0, 0, 0, 0, 0, 0, 0, -1};
        String valid = "00:00:00:00:00:00:00:ff";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToStringBytes2() {
        byte[] dpid = new byte[]{1, 2, 3, 4};
        String valid = "01:02:03:04";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToStringBytes3() {
        byte[] dpid = new byte[]{-1};
        String valid = "ff";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToStringEmpty() {
        byte[] dpid = new byte[]{};
        String valid = "";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToStringLong() {
        byte[] dpid = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        String valid = "01:02:03:04:05:06:07:08:09:0a:0b:0c:0d:0e:0f";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToZero() {
        byte[] dpid = new byte[]{0, 0, 0, 0};
        String valid = "00:00:00:00";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test
    public void testToStringFromLong() {
        Assert.assertThat((Object)HexString.toHexString((long)0L), (Matcher)Matchers.equalTo((Object)"00:00:00:00:00:00:00:00"));
        Assert.assertThat((Object)HexString.toHexString((long)1L), (Matcher)Matchers.equalTo((Object)"00:00:00:00:00:00:00:01"));
        Assert.assertThat((Object)HexString.toHexString((long)72623859790382856L), (Matcher)Matchers.equalTo((Object)"01:02:03:04:05:06:07:08"));
        Assert.assertThat((Object)HexString.toHexString((long)-283686952306184L), (Matcher)Matchers.equalTo((Object)"ff:fe:fd:fc:fb:fa:f9:f8"));
        Assert.assertThat((Object)HexString.toHexString((long)-9191740941672636400L), (Matcher)Matchers.equalTo((Object)"80:70:60:50:40:30:20:10"));
    }

    @Test
    public void testToStringFromLongPad6() {
        Assert.assertThat((Object)HexString.toHexString((long)0L, (int)6), (Matcher)Matchers.equalTo((Object)"00:00:00:00:00:00"));
        Assert.assertThat((Object)HexString.toHexString((long)1L, (int)6), (Matcher)Matchers.equalTo((Object)"00:00:00:00:00:01"));
        Assert.assertThat((Object)HexString.toHexString((long)1108152157446L, (int)6), (Matcher)Matchers.equalTo((Object)"01:02:03:04:05:06"));
        Assert.assertThat((Object)HexString.toHexString((long)281470647991290L, (int)6), (Matcher)Matchers.equalTo((Object)"ff:fe:fd:fc:fb:fa"));
        Assert.assertThat((Object)HexString.toHexString((long)-9191740941672636400L, (int)6), (Matcher)Matchers.equalTo((Object)"80:70:60:50:40:30:20:10"));
    }

    @Test
    public void testToBytes() {
        Assert.assertThat((Object)HexString.toBytes((String)""), (Matcher)Matchers.equalTo((Object)new byte[0]));
        Assert.assertThat((Object)HexString.toBytes((String)"1"), (Matcher)Matchers.equalTo((Object)new byte[]{1}));
        Assert.assertThat((Object)HexString.toBytes((String)"f"), (Matcher)Matchers.equalTo((Object)new byte[]{15}));
        Assert.assertThat((Object)HexString.toBytes((String)"10"), (Matcher)Matchers.equalTo((Object)new byte[]{16}));
        Assert.assertThat((Object)HexString.toBytes((String)"80"), (Matcher)Matchers.equalTo((Object)new byte[]{-128}));
        Assert.assertThat((Object)HexString.toBytes((String)"ff"), (Matcher)Matchers.equalTo((Object)new byte[]{-1}));
        Assert.assertThat((Object)HexString.toBytes((String)"0:0"), (Matcher)Matchers.equalTo((Object)new byte[]{0, 0}));
        Assert.assertThat((Object)HexString.toBytes((String)"00:00"), (Matcher)Matchers.equalTo((Object)new byte[]{0, 0}));
        Assert.assertThat((Object)HexString.toBytes((String)"0:1"), (Matcher)Matchers.equalTo((Object)new byte[]{0, 1}));
        Assert.assertThat((Object)HexString.toBytes((String)"00:1"), (Matcher)Matchers.equalTo((Object)new byte[]{0, 1}));
        Assert.assertThat((Object)HexString.toBytes((String)"0:01"), (Matcher)Matchers.equalTo((Object)new byte[]{0, 1}));
        Assert.assertThat((Object)HexString.toBytes((String)"1:0"), (Matcher)Matchers.equalTo((Object)new byte[]{1, 0}));
        Assert.assertThat((Object)HexString.toBytes((String)"01:00"), (Matcher)Matchers.equalTo((Object)new byte[]{1, 0}));
        Assert.assertThat((Object)HexString.toBytes((String)"01:02:03:04"), (Matcher)Matchers.equalTo((Object)new byte[]{1, 2, 3, 4}));
        Assert.assertThat((Object)HexString.toBytes((String)"ff:fe:03:04"), (Matcher)Matchers.equalTo((Object)new byte[]{-1, -2, 3, 4}));
        Assert.assertThat((Object)HexString.toBytes((String)"ff:fe:3:4"), (Matcher)Matchers.equalTo((Object)new byte[]{-1, -2, 3, 4}));
        Assert.assertThat((Object)HexString.toBytes((String)"01:02:03:04:05:06"), (Matcher)Matchers.equalTo((Object)new byte[]{1, 2, 3, 4, 5, 6}));
        Assert.assertThat((Object)HexString.toBytes((String)"ff:1:fe:2:fd"), (Matcher)Matchers.equalTo((Object)new byte[]{-1, 1, -2, 2, -3}));
    }

    @Test
    public void testToBytesRandom() {
        Random r = new Random();
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4, (Object)5, (Object)6, (Object)7, (Object)8, (Object)15, (Object)16, (Object)32, (Object[])new Integer[]{63, 64, 128, 255, 256, 511, 512, 1023, 1024}).iterator();
        while (unmodifiableIterator.hasNext()) {
            int length = (Integer)unmodifiableIterator.next();
            StringBuilder build = new StringBuilder();
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                byte b = (byte)r.nextInt(256);
                build.append(String.format("%02x", b));
                if (i < length - 1) {
                    build.append(":");
                }
                bytes[i] = b;
            }
            Assert.assertThat((String)("For length " + length + ", "), (Object)HexString.toBytes((String)build.toString()), (Matcher)Matchers.equalTo((Object)bytes));
        }
    }

    @Test(expected=NumberFormatException.class)
    public void testToBytesError() {
        String invalidStr = "00:00:00:00:00:00:ffff";
        HexString.toBytes((String)invalidStr);
    }

    @Test(expected=NumberFormatException.class)
    public void testToBytesError2() {
        String invalidStr = ":01:02:03";
        HexString.toBytes((String)invalidStr);
    }

    @Test(expected=NumberFormatException.class)
    public void testToBytesError3() {
        String invalidStr = "01::02:03";
        HexString.toBytes((String)invalidStr);
    }

    @Test(expected=NumberFormatException.class)
    public void testBoBytesError4() {
        String invalidStr = "01:02:03:";
        HexString.toBytes((String)invalidStr);
    }

    @Test(expected=NumberFormatException.class)
    public void testtoBytesError5() {
        String invalidStr = "01:0X";
        HexString.toBytes((String)invalidStr);
    }
}

