/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFConfigFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFSetConfig;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFSetConfigVer15;

public class OFSetConfigVer15Test {
    OFFactory factory;
    static final byte[] SET_CONFIG_SERIALIZED = new byte[]{6, 9, 0, 12, 18, 52, 86, 120, 0, 2, -1, -1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFSetConfig.Builder builder = this.factory.buildSetConfig();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFSetConfig setConfig = builder.build();
        ByteBuf bb = Unpooled.buffer();
        setConfig.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)SET_CONFIG_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFSetConfig.Builder builder = this.factory.buildSetConfig();
        builder.setXid(305419896L).setFlags((Set)Sets.immutableEnumSet((Enum)OFConfigFlags.FRAG_REASM, (Enum[])new OFConfigFlags[0])).setMissSendLen(65535).build();
        OFSetConfig setConfigBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])SET_CONFIG_SERIALIZED);
        OFSetConfig setConfigRead = OFSetConfigVer15.READER.readFrom(input);
        Assert.assertEquals((long)SET_CONFIG_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)setConfigBuilt, (Object)setConfigRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])SET_CONFIG_SERIALIZED);
        OFSetConfig setConfig = OFSetConfigVer15.READER.readFrom(input);
        Assert.assertEquals((long)SET_CONFIG_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        setConfig.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)SET_CONFIG_SERIALIZED));
    }
}

