/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableDescStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableDescStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.GenTableId;

public class OFBsnGentableDescStatsReplyVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED = new byte[]{4, 19, 0, 120, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, 0, 92, 22, -57, 0, 0, 0, 4, 0, 48, 0, 0, 116, 97, 98, 108, 101, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 64, 0, 0, 0, 0, 0, 48, 0, 1, 116, 97, 98, 108, 101, 32, 49, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 0, 0, 0, 64, 0, 0, 0, -128, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableDescStatsReply.Builder builder = this.factory.buildBsnGentableDescStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.buildBsnGentableDescStatsEntry().setTableId(GenTableId.of((int)0)).setName("table 0").setBucketsSize(32L).setMaxEntries(64L).build(), (Object)this.factory.buildBsnGentableDescStatsEntry().setTableId(GenTableId.of((int)1)).setName("table 1.........................").setBucketsSize(64L).setMaxEntries(128L).build()));
        OFBsnGentableDescStatsReply bsnGentableDescStatsReply = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bsnGentableDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableDescStatsReply.Builder builder = this.factory.buildBsnGentableDescStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.buildBsnGentableDescStatsEntry().setTableId(GenTableId.of((int)0)).setName("table 0").setBucketsSize(32L).setMaxEntries(64L).build(), (Object)this.factory.buildBsnGentableDescStatsEntry().setTableId(GenTableId.of((int)1)).setName("table 1.........................").setBucketsSize(64L).setMaxEntries(128L).build()));
        OFBsnGentableDescStatsReply bsnGentableDescStatsReplyBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED);
        OFBsnGentableDescStatsReply bsnGentableDescStatsReplyRead = OFBsnGentableDescStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableDescStatsReplyBuilt, (Object)bsnGentableDescStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED);
        OFBsnGentableDescStatsReply bsnGentableDescStatsReply = OFBsnGentableDescStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bsnGentableDescStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_DESC_STATS_REPLY_SERIALIZED));
    }
}

