// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFFlowStatsEntryVer15 implements OFFlowStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowStatsEntryVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 40;
    // maximum OF message length: 16 bit, unsigned
    final static int MAXIMUM_LENGTH = 0xFFFF;

        private final static TableId DEFAULT_TABLE_ID = TableId.ALL;
        private final static int DEFAULT_PRIORITY = 0x0;
        private final static int DEFAULT_IDLE_TIMEOUT = 0x0;
        private final static int DEFAULT_HARD_TIMEOUT = 0x0;
        private final static Set<OFFlowModFlags> DEFAULT_FLAGS = ImmutableSet.<OFFlowModFlags>of();
        private final static int DEFAULT_IMPORTANCE = 0x0;
        private final static U64 DEFAULT_COOKIE = U64.ZERO;
        private final static Match DEFAULT_MATCH = OFFactoryVer15.MATCH_WILDCARD_ALL;
        private final static List<OFInstruction> DEFAULT_INSTRUCTIONS = ImmutableList.<OFInstruction>of();

    // OF message fields
    private final TableId tableId;
    private final int priority;
    private final int idleTimeout;
    private final int hardTimeout;
    private final Set<OFFlowModFlags> flags;
    private final int importance;
    private final U64 cookie;
    private final Match match;
    private final Stat stats;
    private final List<OFInstruction> instructions;
//

    // package private constructor - used by readers, builders, and factory
    OFFlowStatsEntryVer15(TableId tableId, int priority, int idleTimeout, int hardTimeout, Set<OFFlowModFlags> flags, int importance, U64 cookie, Match match, Stat stats, List<OFInstruction> instructions) {
        if(tableId == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property tableId cannot be null");
        }
        if(flags == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property flags cannot be null");
        }
        if(cookie == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property cookie cannot be null");
        }
        if(match == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property match cannot be null");
        }
        if(stats == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property stats cannot be null");
        }
        if(instructions == null) {
            throw new NullPointerException("OFFlowStatsEntryVer15: property instructions cannot be null");
        }
        this.tableId = tableId;
        this.priority = U16.normalize(priority);
        this.idleTimeout = U16.normalize(idleTimeout);
        this.hardTimeout = U16.normalize(hardTimeout);
        this.flags = flags;
        this.importance = U16.normalize(importance);
        this.cookie = cookie;
        this.match = match;
        this.stats = stats;
        this.instructions = instructions;
    }

    // Accessors for OF message fields
    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public List<OFAction> getActions()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }

    @Override
    public int getImportance() {
        return importance;
    }

    @Override
    public Stat getStats() {
        return stats;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



    public OFFlowStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFFlowStatsEntry.Builder {
        final OFFlowStatsEntryVer15 parentMessage;

        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean importanceSet;
        private int importance;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

        BuilderWithParent(OFFlowStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }
    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFFlowStatsEntry.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }
    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFFlowStatsEntry.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsSet = true;
        return this;
    }
    @Override
    public List<OFAction> getActions()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }
    @Override
    public int getImportance() {
        return importance;
    }

    @Override
    public OFFlowStatsEntry.Builder setImportance(int importance) {
        this.importance = importance;
        this.importanceSet = true;
        return this;
    }
    @Override
    public Stat getStats() {
        return stats;
    }

    @Override
    public OFFlowStatsEntry.Builder setStats(Stat stats) {
        this.stats = stats;
        this.statsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }



        @Override
        public OFFlowStatsEntry build() {
                TableId tableId = this.tableIdSet ? this.tableId : parentMessage.tableId;
                if(tableId == null)
                    throw new NullPointerException("Property tableId must not be null");
                int priority = this.prioritySet ? this.priority : parentMessage.priority;
                int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : parentMessage.idleTimeout;
                int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : parentMessage.hardTimeout;
                Set<OFFlowModFlags> flags = this.flagsSet ? this.flags : parentMessage.flags;
                if(flags == null)
                    throw new NullPointerException("Property flags must not be null");
                int importance = this.importanceSet ? this.importance : parentMessage.importance;
                U64 cookie = this.cookieSet ? this.cookie : parentMessage.cookie;
                if(cookie == null)
                    throw new NullPointerException("Property cookie must not be null");
                Match match = this.matchSet ? this.match : parentMessage.match;
                if(match == null)
                    throw new NullPointerException("Property match must not be null");
                Stat stats = this.statsSet ? this.stats : parentMessage.stats;
                if(stats == null)
                    throw new NullPointerException("Property stats must not be null");
                List<OFInstruction> instructions = this.instructionsSet ? this.instructions : parentMessage.instructions;
                if(instructions == null)
                    throw new NullPointerException("Property instructions must not be null");

                //
                return new OFFlowStatsEntryVer15(
                    tableId,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    flags,
                    importance,
                    cookie,
                    match,
                    stats,
                    instructions
                );
        }

    }

    static class Builder implements OFFlowStatsEntry.Builder {
        // OF message fields
        private boolean tableIdSet;
        private TableId tableId;
        private boolean prioritySet;
        private int priority;
        private boolean idleTimeoutSet;
        private int idleTimeout;
        private boolean hardTimeoutSet;
        private int hardTimeout;
        private boolean flagsSet;
        private Set<OFFlowModFlags> flags;
        private boolean importanceSet;
        private int importance;
        private boolean cookieSet;
        private U64 cookie;
        private boolean matchSet;
        private Match match;
        private boolean statsSet;
        private Stat stats;
        private boolean instructionsSet;
        private List<OFInstruction> instructions;

    @Override
    public TableId getTableId() {
        return tableId;
    }

    @Override
    public OFFlowStatsEntry.Builder setTableId(TableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public long getDurationSec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setDurationSec(long durationSec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationSec not supported in version 1.5");
    }
    @Override
    public long getDurationNsec()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setDurationNsec(long durationNsec) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property durationNsec not supported in version 1.5");
    }
    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public OFFlowStatsEntry.Builder setPriority(int priority) {
        this.priority = priority;
        this.prioritySet = true;
        return this;
    }
    @Override
    public int getIdleTimeout() {
        return idleTimeout;
    }

    @Override
    public OFFlowStatsEntry.Builder setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.idleTimeoutSet = true;
        return this;
    }
    @Override
    public int getHardTimeout() {
        return hardTimeout;
    }

    @Override
    public OFFlowStatsEntry.Builder setHardTimeout(int hardTimeout) {
        this.hardTimeout = hardTimeout;
        this.hardTimeoutSet = true;
        return this;
    }
    @Override
    public Set<OFFlowModFlags> getFlags() {
        return flags;
    }

    @Override
    public OFFlowStatsEntry.Builder setFlags(Set<OFFlowModFlags> flags) {
        this.flags = flags;
        this.flagsSet = true;
        return this;
    }
    @Override
    public U64 getCookie() {
        return cookie;
    }

    @Override
    public OFFlowStatsEntry.Builder setCookie(U64 cookie) {
        this.cookie = cookie;
        this.cookieSet = true;
        return this;
    }
    @Override
    public U64 getPacketCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setPacketCount(U64 packetCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property packetCount not supported in version 1.5");
    }
    @Override
    public U64 getByteCount()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setByteCount(U64 byteCount) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property byteCount not supported in version 1.5");
    }
    @Override
    public Match getMatch() {
        return match;
    }

    @Override
    public OFFlowStatsEntry.Builder setMatch(Match match) {
        this.match = match;
        this.matchSet = true;
        return this;
    }
    @Override
    public List<OFInstruction> getInstructions() {
        return instructions;
    }

    @Override
    public OFFlowStatsEntry.Builder setInstructions(List<OFInstruction> instructions) {
        this.instructions = instructions;
        this.instructionsSet = true;
        return this;
    }
    @Override
    public List<OFAction> getActions()throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }

    @Override
    public OFFlowStatsEntry.Builder setActions(List<OFAction> actions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property actions not supported in version 1.5");
    }
    @Override
    public int getImportance() {
        return importance;
    }

    @Override
    public OFFlowStatsEntry.Builder setImportance(int importance) {
        this.importance = importance;
        this.importanceSet = true;
        return this;
    }
    @Override
    public Stat getStats() {
        return stats;
    }

    @Override
    public OFFlowStatsEntry.Builder setStats(Stat stats) {
        this.stats = stats;
        this.statsSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

//
        @Override
        public OFFlowStatsEntry build() {
            TableId tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if(tableId == null)
                throw new NullPointerException("Property tableId must not be null");
            int priority = this.prioritySet ? this.priority : DEFAULT_PRIORITY;
            int idleTimeout = this.idleTimeoutSet ? this.idleTimeout : DEFAULT_IDLE_TIMEOUT;
            int hardTimeout = this.hardTimeoutSet ? this.hardTimeout : DEFAULT_HARD_TIMEOUT;
            Set<OFFlowModFlags> flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if(flags == null)
                throw new NullPointerException("Property flags must not be null");
            int importance = this.importanceSet ? this.importance : DEFAULT_IMPORTANCE;
            U64 cookie = this.cookieSet ? this.cookie : DEFAULT_COOKIE;
            if(cookie == null)
                throw new NullPointerException("Property cookie must not be null");
            Match match = this.matchSet ? this.match : DEFAULT_MATCH;
            if(match == null)
                throw new NullPointerException("Property match must not be null");
            if(!this.statsSet)
                throw new IllegalStateException("Property stats doesn't have default value -- must be set");
            if(stats == null)
                throw new NullPointerException("Property stats must not be null");
            List<OFInstruction> instructions = this.instructionsSet ? this.instructions : DEFAULT_INSTRUCTIONS;
            if(instructions == null)
                throw new NullPointerException("Property instructions must not be null");


            return new OFFlowStatsEntryVer15(
                    tableId,
                    priority,
                    idleTimeout,
                    hardTimeout,
                    flags,
                    importance,
                    cookie,
                    match,
                    stats,
                    instructions
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFFlowStatsEntry> {
        @Override
        public OFFlowStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            // pad: 2 bytes
            bb.skipBytes(2);
            TableId tableId = TableId.readByte(bb);
            // pad: 1 bytes
            bb.skipBytes(1);
            int priority = U16.f(bb.readShort());
            int idleTimeout = U16.f(bb.readShort());
            int hardTimeout = U16.f(bb.readShort());
            Set<OFFlowModFlags> flags = OFFlowModFlagsSerializerVer15.readFrom(bb);
            int importance = U16.f(bb.readShort());
            U64 cookie = U64.ofRaw(bb.readLong());
            Match match = ChannelUtilsVer15.readOFMatch(bb);
            Stat stats = ChannelUtilsVer15.readOFStat(bb);
            List<OFInstruction> instructions = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFInstructionVer15.READER);

            OFFlowStatsEntryVer15 flowStatsEntryVer15 = new OFFlowStatsEntryVer15(
                    tableId,
                      priority,
                      idleTimeout,
                      hardTimeout,
                      flags,
                      importance,
                      cookie,
                      match,
                      stats,
                      instructions
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", flowStatsEntryVer15);
            return flowStatsEntryVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFFlowStatsEntryVer15Funnel FUNNEL = new OFFlowStatsEntryVer15Funnel();
    static class OFFlowStatsEntryVer15Funnel implements Funnel<OFFlowStatsEntryVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFFlowStatsEntryVer15 message, PrimitiveSink sink) {
            // FIXME: skip funnel of length
            // skip pad (2 bytes)
            message.tableId.putTo(sink);
            // skip pad (1 bytes)
            sink.putInt(message.priority);
            sink.putInt(message.idleTimeout);
            sink.putInt(message.hardTimeout);
            OFFlowModFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(message.importance);
            message.cookie.putTo(sink);
            message.match.putTo(sink);
            message.stats.putTo(sink);
            FunnelUtils.putList(message.instructions, sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFFlowStatsEntryVer15> {
        @Override
        public void write(ByteBuf bb, OFFlowStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            // pad: 2 bytes
            bb.writeZero(2);
            message.tableId.writeByte(bb);
            // pad: 1 bytes
            bb.writeZero(1);
            bb.writeShort(U16.t(message.priority));
            bb.writeShort(U16.t(message.idleTimeout));
            bb.writeShort(U16.t(message.hardTimeout));
            OFFlowModFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeShort(U16.t(message.importance));
            bb.writeLong(message.cookie.getValue());
            message.match.writeTo(bb);
            message.stats.writeTo(bb);
            ChannelUtils.writeList(bb, message.instructions);

            // update length field
            int length = bb.writerIndex() - startIndex;
            if (length > MAXIMUM_LENGTH) {
                throw new IllegalArgumentException("OFFlowStatsEntryVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowStatsEntryVer15(");
        b.append("tableId=").append(tableId);
        b.append(", ");
        b.append("priority=").append(priority);
        b.append(", ");
        b.append("idleTimeout=").append(idleTimeout);
        b.append(", ");
        b.append("hardTimeout=").append(hardTimeout);
        b.append(", ");
        b.append("flags=").append(flags);
        b.append(", ");
        b.append("importance=").append(importance);
        b.append(", ");
        b.append("cookie=").append(cookie);
        b.append(", ");
        b.append("match=").append(match);
        b.append(", ");
        b.append("stats=").append(stats);
        b.append(", ");
        b.append("instructions=").append(instructions);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFFlowStatsEntryVer15 other = (OFFlowStatsEntryVer15) obj;

        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if( priority != other.priority)
            return false;
        if( idleTimeout != other.idleTimeout)
            return false;
        if( hardTimeout != other.hardTimeout)
            return false;
        if (flags == null) {
            if (other.flags != null)
                return false;
        } else if (!flags.equals(other.flags))
            return false;
        if( importance != other.importance)
            return false;
        if (cookie == null) {
            if (other.cookie != null)
                return false;
        } else if (!cookie.equals(other.cookie))
            return false;
        if (match == null) {
            if (other.match != null)
                return false;
        } else if (!match.equals(other.match))
            return false;
        if (stats == null) {
            if (other.stats != null)
                return false;
        } else if (!stats.equals(other.stats))
            return false;
        if (instructions == null) {
            if (other.instructions != null)
                return false;
        } else if (!instructions.equals(other.instructions))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + priority;
        result = prime * result + idleTimeout;
        result = prime * result + hardTimeout;
        result = prime * result + ((flags == null) ? 0 : flags.hashCode());
        result = prime * result + importance;
        result = prime * result + ((cookie == null) ? 0 : cookie.hashCode());
        result = prime * result + ((match == null) ? 0 : match.hashCode());
        result = prime * result + ((stats == null) ? 0 : stats.hashCode());
        result = prime * result + ((instructions == null) ? 0 : instructions.hashCode());
        return result;
    }

}
