/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver15.OFFactoryVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFPacketOutVer15;
import org.projectfloodlight.openflow.types.ArpOpcode;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFPacketOutVer15Test {
    OFFactory factory;
    static final byte[] PACKET_OUT_SERIALIZED = new byte[]{6, 13, 0, 67, 18, 52, 86, 120, 0, 0, 0, 100, 0, 24, 0, 0, 0, 1, 0, 22, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, -128, 0, 42, 2, 0, 1, 0, 0, 0, 0, 0, 16, 0, 0, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 24, 0, 8, 0, 0, 0, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer15.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPacketOut.Builder builder = this.factory.buildPacketOut();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)100)).setMatch(this.factory.buildMatchV3().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.REQUEST).build()).setActions(Arrays.asList(this.factory.actions().buildOutput().setPort(OFPort.of((int)2)).setMaxLen(65535).build(), this.factory.actions().decNwTtl())).setData(new byte[]{97, 98, 99}).build();
        OFPacketOut packetOut = builder.build();
        ByteBuf bb = Unpooled.buffer();
        packetOut.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_OUT_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPacketOut.Builder builder = this.factory.buildPacketOut();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)100)).setMatch(this.factory.buildMatchV3().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ARP_OP, (OFValueType)ArpOpcode.REQUEST).build()).setActions(Arrays.asList(this.factory.actions().buildOutput().setPort(OFPort.of((int)2)).setMaxLen(65535).build(), this.factory.actions().decNwTtl())).setData(new byte[]{97, 98, 99}).build();
        OFPacketOut packetOutBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])PACKET_OUT_SERIALIZED);
        OFPacketOut packetOutRead = OFPacketOutVer15.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_OUT_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)packetOutBuilt, (Object)packetOutRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])PACKET_OUT_SERIALIZED);
        OFPacketOut packetOut = OFPacketOutVer15.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_OUT_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        packetOut.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_OUT_SERIALIZED));
    }
}

