// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver15;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Set;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFBsnGentableErrorVer15 implements OFBsnGentableError {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGentableErrorVer15.class);
    // version: 1.5
    final static byte WIRE_VERSION = 6;
    final static int MINIMUM_LENGTH = 276;

        private final static long DEFAULT_XID = 0x0L;
        private final static String DEFAULT_ERR_MSG = "";
        private final static OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;

    // OF message fields
    private final long xid;
    private final OFBsnGentableErrorCode errorCode;
    private final GenTableId tableId;
    private final String errMsg;
    private final OFErrorCauseData data;
//

    // package private constructor - used by readers, builders, and factory
    OFBsnGentableErrorVer15(long xid, OFBsnGentableErrorCode errorCode, GenTableId tableId, String errMsg, OFErrorCauseData data) {
        if(errorCode == null) {
            throw new NullPointerException("OFBsnGentableErrorVer15: property errorCode cannot be null");
        }
        if(tableId == null) {
            throw new NullPointerException("OFBsnGentableErrorVer15: property tableId cannot be null");
        }
        if(errMsg == null) {
            throw new NullPointerException("OFBsnGentableErrorVer15: property errMsg cannot be null");
        }
        if(data == null) {
            throw new NullPointerException("OFBsnGentableErrorVer15: property data cannot be null");
        }
        this.xid = xid;
        this.errorCode = errorCode;
        this.tableId = tableId;
        this.errMsg = errMsg;
        this.data = data;
    }

    // Accessors for OF message fields
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return 0x2;
    }

    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public OFBsnGentableErrorCode getErrorCode() {
        return errorCode;
    }

    @Override
    public GenTableId getTableId() {
        return tableId;
    }

    @Override
    public String getErrMsg() {
        return errMsg;
    }

    @Override
    public OFErrorCauseData getData() {
        return data;
    }



    public OFBsnGentableError.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFBsnGentableError.Builder {
        final OFBsnGentableErrorVer15 parentMessage;

        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean errorCodeSet;
        private OFBsnGentableErrorCode errorCode;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFBsnGentableErrorVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFBsnGentableError.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return 0x2;
    }

    @Override
    public OFBsnGentableError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
    }
    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public OFBsnGentableErrorCode getErrorCode() {
        return errorCode;
    }

    @Override
    public OFBsnGentableError.Builder setErrorCode(OFBsnGentableErrorCode errorCode) {
        this.errorCode = errorCode;
        this.errorCodeSet = true;
        return this;
    }
    @Override
    public GenTableId getTableId() {
        return tableId;
    }

    @Override
    public OFBsnGentableError.Builder setTableId(GenTableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public String getErrMsg() {
        return errMsg;
    }

    @Override
    public OFBsnGentableError.Builder setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        this.errMsgSet = true;
        return this;
    }
    @Override
    public OFErrorCauseData getData() {
        return data;
    }

    @Override
    public OFBsnGentableError.Builder setData(OFErrorCauseData data) {
        this.data = data;
        this.dataSet = true;
        return this;
    }


        @Override
        public OFBsnGentableError build() {
                long xid = this.xidSet ? this.xid : parentMessage.xid;
                OFBsnGentableErrorCode errorCode = this.errorCodeSet ? this.errorCode : parentMessage.errorCode;
                if(errorCode == null)
                    throw new NullPointerException("Property errorCode must not be null");
                GenTableId tableId = this.tableIdSet ? this.tableId : parentMessage.tableId;
                if(tableId == null)
                    throw new NullPointerException("Property tableId must not be null");
                String errMsg = this.errMsgSet ? this.errMsg : parentMessage.errMsg;
                if(errMsg == null)
                    throw new NullPointerException("Property errMsg must not be null");
                OFErrorCauseData data = this.dataSet ? this.data : parentMessage.data;
                if(data == null)
                    throw new NullPointerException("Property data must not be null");

                //
                return new OFBsnGentableErrorVer15(
                    xid,
                    errorCode,
                    tableId,
                    errMsg,
                    data
                );
        }

    }

    static class Builder implements OFBsnGentableError.Builder {
        // OF message fields
        private boolean xidSet;
        private long xid;
        private boolean errorCodeSet;
        private OFBsnGentableErrorCode errorCode;
        private boolean tableIdSet;
        private GenTableId tableId;
        private boolean errMsgSet;
        private String errMsg;
        private boolean dataSet;
        private OFErrorCauseData data;

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return xid;
    }

    @Override
    public OFBsnGentableError.Builder setXid(long xid) {
        this.xid = xid;
        this.xidSet = true;
        return this;
    }
    @Override
    public OFErrorType getErrType() {
        return OFErrorType.EXPERIMENTER;
    }

    @Override
    public int getSubtype() {
        return 0x2;
    }

    @Override
    public OFBsnGentableError.Builder setSubtype(int subtype) {
            throw new UnsupportedOperationException("Property subtype is not writeable");
    }
    @Override
    public long getExperimenter() {
        return 0x5c16c7L;
    }

    @Override
    public OFBsnGentableErrorCode getErrorCode() {
        return errorCode;
    }

    @Override
    public OFBsnGentableError.Builder setErrorCode(OFBsnGentableErrorCode errorCode) {
        this.errorCode = errorCode;
        this.errorCodeSet = true;
        return this;
    }
    @Override
    public GenTableId getTableId() {
        return tableId;
    }

    @Override
    public OFBsnGentableError.Builder setTableId(GenTableId tableId) {
        this.tableId = tableId;
        this.tableIdSet = true;
        return this;
    }
    @Override
    public String getErrMsg() {
        return errMsg;
    }

    @Override
    public OFBsnGentableError.Builder setErrMsg(String errMsg) {
        this.errMsg = errMsg;
        this.errMsgSet = true;
        return this;
    }
    @Override
    public OFErrorCauseData getData() {
        return data;
    }

    @Override
    public OFBsnGentableError.Builder setData(OFErrorCauseData data) {
        this.data = data;
        this.dataSet = true;
        return this;
    }
//
        @Override
        public OFBsnGentableError build() {
            long xid = this.xidSet ? this.xid : DEFAULT_XID;
            if(!this.errorCodeSet)
                throw new IllegalStateException("Property errorCode doesn't have default value -- must be set");
            if(errorCode == null)
                throw new NullPointerException("Property errorCode must not be null");
            if(!this.tableIdSet)
                throw new IllegalStateException("Property tableId doesn't have default value -- must be set");
            if(tableId == null)
                throw new NullPointerException("Property tableId must not be null");
            String errMsg = this.errMsgSet ? this.errMsg : DEFAULT_ERR_MSG;
            if(errMsg == null)
                throw new NullPointerException("Property errMsg must not be null");
            OFErrorCauseData data = this.dataSet ? this.data : DEFAULT_DATA;
            if(data == null)
                throw new NullPointerException("Property data must not be null");


            return new OFBsnGentableErrorVer15(
                    xid,
                    errorCode,
                    tableId,
                    errMsg,
                    data
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFBsnGentableError> {
        @Override
        public OFBsnGentableError readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property version == 6
            byte version = bb.readByte();
            if(version != (byte) 0x6)
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got="+version);
            // fixed value property type == 1
            byte type = bb.readByte();
            if(type != (byte) 0x1)
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got="+type);
            int length = U16.f(bb.readShort());
            if(length < MINIMUM_LENGTH)
                throw new OFParseError("Wrong length: Expected to be >= " + MINIMUM_LENGTH + ", was: " + length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long xid = U32.f(bb.readInt());
            // fixed value property errType == 65535
            short errType = bb.readShort();
            if(errType != (short) 0xffff)
                throw new OFParseError("Wrong errType: Expected=OFErrorType.EXPERIMENTER(65535), got="+errType);
            // fixed value property subtype == 0x2
            short subtype = bb.readShort();
            if(subtype != (short) 0x2)
                throw new OFParseError("Wrong subtype: Expected=0x2(0x2), got="+subtype);
            // fixed value property experimenter == 0x5c16c7L
            int experimenter = bb.readInt();
            if(experimenter != 0x5c16c7)
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got="+experimenter);
            OFBsnGentableErrorCode errorCode = OFBsnGentableErrorCodeSerializerVer15.readFrom(bb);
            GenTableId tableId = GenTableId.read2Bytes(bb);
            String errMsg = ChannelUtils.readFixedLengthString(bb, 256);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_15);

            OFBsnGentableErrorVer15 bsnGentableErrorVer15 = new OFBsnGentableErrorVer15(
                    xid,
                      errorCode,
                      tableId,
                      errMsg,
                      data
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", bsnGentableErrorVer15);
            return bsnGentableErrorVer15;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFBsnGentableErrorVer15Funnel FUNNEL = new OFBsnGentableErrorVer15Funnel();
    static class OFBsnGentableErrorVer15Funnel implements Funnel<OFBsnGentableErrorVer15> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFBsnGentableErrorVer15 message, PrimitiveSink sink) {
            // fixed value property version = 6
            sink.putByte((byte) 0x6);
            // fixed value property type = 1
            sink.putByte((byte) 0x1);
            // FIXME: skip funnel of length
            sink.putLong(message.xid);
            // fixed value property errType = 65535
            sink.putShort((short) 0xffff);
            // fixed value property subtype = 0x2
            sink.putShort((short) 0x2);
            // fixed value property experimenter = 0x5c16c7L
            sink.putInt(0x5c16c7);
            OFBsnGentableErrorCodeSerializerVer15.putTo(message.errorCode, sink);
            message.tableId.putTo(sink);
            sink.putUnencodedChars(message.errMsg);
            message.data.putTo(sink);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFBsnGentableErrorVer15> {
        @Override
        public void write(ByteBuf bb, OFBsnGentableErrorVer15 message) {
            int startIndex = bb.writerIndex();
            // fixed value property version = 6
            bb.writeByte((byte) 0x6);
            // fixed value property type = 1
            bb.writeByte((byte) 0x1);
            // length is length of variable message, will be updated at the end
            int lengthIndex = bb.writerIndex();
            bb.writeShort(U16.t(0));

            bb.writeInt(U32.t(message.xid));
            // fixed value property errType = 65535
            bb.writeShort((short) 0xffff);
            // fixed value property subtype = 0x2
            bb.writeShort((short) 0x2);
            // fixed value property experimenter = 0x5c16c7L
            bb.writeInt(0x5c16c7);
            OFBsnGentableErrorCodeSerializerVer15.writeTo(bb, message.errorCode);
            message.tableId.write2Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.errMsg, 256);
            message.data.writeTo(bb);

            // update length field
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);

        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGentableErrorVer15(");
        b.append("xid=").append(xid);
        b.append(", ");
        b.append("errorCode=").append(errorCode);
        b.append(", ");
        b.append("tableId=").append(tableId);
        b.append(", ");
        b.append("errMsg=").append(errMsg);
        b.append(", ");
        b.append("data=").append(data);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnGentableErrorVer15 other = (OFBsnGentableErrorVer15) obj;

        if( xid != other.xid)
            return false;
        if (errorCode == null) {
            if (other.errorCode != null)
                return false;
        } else if (!errorCode.equals(other.errorCode))
            return false;
        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if (errMsg == null) {
            if (other.errMsg != null)
                return false;
        } else if (!errMsg.equals(other.errMsg))
            return false;
        if (data == null) {
            if (other.data != null)
                return false;
        } else if (!data.equals(other.data))
            return false;
        return true;
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFBsnGentableErrorVer15 other = (OFBsnGentableErrorVer15) obj;

        // ignore XID
        if (errorCode == null) {
            if (other.errorCode != null)
                return false;
        } else if (!errorCode.equals(other.errorCode))
            return false;
        if (tableId == null) {
            if (other.tableId != null)
                return false;
        } else if (!tableId.equals(other.tableId))
            return false;
        if (errMsg == null) {
            if (other.errMsg != null)
                return false;
        } else if (!errMsg.equals(other.errMsg))
            return false;
        if (data == null) {
            if (other.data != null)
                return false;
        } else if (!data.equals(other.data))
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (xid ^ (xid >>> 32));
        result = prime * result + ((errorCode == null) ? 0 : errorCode.hashCode());
        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + ((errMsg == null) ? 0 : errMsg.hashCode());
        result = prime * result + ((data == null) ? 0 : data.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        final int prime = 31;
        int result = 1;

        // ignore XID
        result = prime * result + ((errorCode == null) ? 0 : errorCode.hashCode());
        result = prime * result + ((tableId == null) ? 0 : tableId.hashCode());
        result = prime * result + ((errMsg == null) ? 0 : errMsg.hashCode());
        result = prime * result + ((data == null) ? 0 : data.hashCode());
        return result;
    }

}
