// Copyright (c) 2008 The Board of Trustees of The Leland Stanford Junior University
// Copyright (c) 2011, 2012 Open Networking Foundation
// Copyright (c) 2012, 2013 Big Switch Networks, Inc.
// This library was generated by the LoxiGen Compiler.
// See the file LICENSE.txt which should have been included in the source distribution

// Automatically generated by LOXI from template of_class.java
// Do not modify

package org.projectfloodlight.openflow.protocol.ver11;

import org.projectfloodlight.openflow.protocol.*;
import org.projectfloodlight.openflow.protocol.action.*;
import org.projectfloodlight.openflow.protocol.actionid.*;
import org.projectfloodlight.openflow.protocol.bsntlv.*;
import org.projectfloodlight.openflow.protocol.errormsg.*;
import org.projectfloodlight.openflow.protocol.meterband.*;
import org.projectfloodlight.openflow.protocol.instruction.*;
import org.projectfloodlight.openflow.protocol.instructionid.*;
import org.projectfloodlight.openflow.protocol.match.*;
import org.projectfloodlight.openflow.protocol.stat.*;
import org.projectfloodlight.openflow.protocol.oxm.*;
import org.projectfloodlight.openflow.protocol.oxs.*;
import org.projectfloodlight.openflow.protocol.queueprop.*;
import org.projectfloodlight.openflow.types.*;
import org.projectfloodlight.openflow.util.*;
import org.projectfloodlight.openflow.exceptions.*;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import io.netty.buffer.ByteBuf;
import com.google.common.hash.PrimitiveSink;
import com.google.common.hash.Funnel;

class OFActionSetMplsLabelVer11 implements OFActionSetMplsLabel {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetMplsLabelVer11.class);
    // version: 1.1
    final static byte WIRE_VERSION = 2;
    final static int LENGTH = 8;

        private final static long DEFAULT_MPLS_LABEL = 0x0L;

    // OF message fields
    private final long mplsLabel;
//
    // Immutable default instance
    final static OFActionSetMplsLabelVer11 DEFAULT = new OFActionSetMplsLabelVer11(
        DEFAULT_MPLS_LABEL
    );

    // package private constructor - used by readers, builders, and factory
    OFActionSetMplsLabelVer11(long mplsLabel) {
        this.mplsLabel = mplsLabel;
    }

    // Accessors for OF message fields
    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_LABEL;
    }

    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }



    public OFActionSetMplsLabel.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    static class BuilderWithParent implements OFActionSetMplsLabel.Builder {
        final OFActionSetMplsLabelVer11 parentMessage;

        // OF message fields
        private boolean mplsLabelSet;
        private long mplsLabel;

        BuilderWithParent(OFActionSetMplsLabelVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_LABEL;
    }

    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public OFActionSetMplsLabel.Builder setMplsLabel(long mplsLabel) {
        this.mplsLabel = mplsLabel;
        this.mplsLabelSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }



        @Override
        public OFActionSetMplsLabel build() {
                long mplsLabel = this.mplsLabelSet ? this.mplsLabel : parentMessage.mplsLabel;

                //
                return new OFActionSetMplsLabelVer11(
                    mplsLabel
                );
        }

    }

    static class Builder implements OFActionSetMplsLabel.Builder {
        // OF message fields
        private boolean mplsLabelSet;
        private long mplsLabel;

    @Override
    public OFActionType getType() {
        return OFActionType.SET_MPLS_LABEL;
    }

    @Override
    public long getMplsLabel() {
        return mplsLabel;
    }

    @Override
    public OFActionSetMplsLabel.Builder setMplsLabel(long mplsLabel) {
        this.mplsLabel = mplsLabel;
        this.mplsLabelSet = true;
        return this;
    }
    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

//
        @Override
        public OFActionSetMplsLabel build() {
            long mplsLabel = this.mplsLabelSet ? this.mplsLabel : DEFAULT_MPLS_LABEL;


            return new OFActionSetMplsLabelVer11(
                    mplsLabel
                );
        }

    }


    final static Reader READER = new Reader();
    static class Reader implements OFMessageReader<OFActionSetMplsLabel> {
        @Override
        public OFActionSetMplsLabel readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            // fixed value property type == 13
            short type = bb.readShort();
            if(type != (short) 0xd)
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_MPLS_LABEL(13), got="+type);
            int length = U16.f(bb.readShort());
            if(length != 8)
                throw new OFParseError("Wrong length: Expected=8(8), got="+length);
            if(bb.readableBytes() + (bb.readerIndex() - start) < length) {
                // Buffer does not have all data yet
                bb.readerIndex(start);
                return null;
            }
            if(logger.isTraceEnabled())
                logger.trace("readFrom - length={}", length);
            long mplsLabel = U32.f(bb.readInt());

            OFActionSetMplsLabelVer11 actionSetMplsLabelVer11 = new OFActionSetMplsLabelVer11(
                    mplsLabel
                    );
            if(logger.isTraceEnabled())
                logger.trace("readFrom - read={}", actionSetMplsLabelVer11);
            return actionSetMplsLabelVer11;
        }
    }

    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    final static OFActionSetMplsLabelVer11Funnel FUNNEL = new OFActionSetMplsLabelVer11Funnel();
    static class OFActionSetMplsLabelVer11Funnel implements Funnel<OFActionSetMplsLabelVer11> {
        private static final long serialVersionUID = 1L;
        @Override
        public void funnel(OFActionSetMplsLabelVer11 message, PrimitiveSink sink) {
            // fixed value property type = 13
            sink.putShort((short) 0xd);
            // fixed value property length = 8
            sink.putShort((short) 0x8);
            sink.putLong(message.mplsLabel);
        }
    }


    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    final static Writer WRITER = new Writer();
    static class Writer implements OFMessageWriter<OFActionSetMplsLabelVer11> {
        @Override
        public void write(ByteBuf bb, OFActionSetMplsLabelVer11 message) {
            // fixed value property type = 13
            bb.writeShort((short) 0xd);
            // fixed value property length = 8
            bb.writeShort((short) 0x8);
            bb.writeInt(U32.t(message.mplsLabel));


        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetMplsLabelVer11(");
        b.append("mplsLabel=").append(mplsLabel);
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OFActionSetMplsLabelVer11 other = (OFActionSetMplsLabelVer11) obj;

        if( mplsLabel != other.mplsLabel)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;

        result = prime *  (int) (mplsLabel ^ (mplsLabel >>> 32));
        return result;
    }

}
