/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnVirtualPortCreateRequest;
import org.projectfloodlight.openflow.protocol.OFBsnVport;
import org.projectfloodlight.openflow.protocol.OFBsnVportL2GreFlags;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnVirtualPortCreateRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;

public class OFBsnVirtualPortCreateRequestVer13L2GreTest {
    OFFactory factory;
    static final byte[] BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED = new byte[]{4, 4, 0, 80, 1, 2, 3, 4, 0, 92, 22, -57, 0, 0, 0, 15, 0, 1, 0, 64, 0, 0, 0, 27, 0, 0, 0, 1, 0, 0, 0, 2, 10, 11, 12, 13, 14, 15, 1, 2, 3, 4, 5, 6, -64, 0, 0, 2, -64, 0, 16, 2, 1, 64, 0, 0, 0, 0, -66, -17, 0, 0, 4, 0, 102, 111, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnVirtualPortCreateRequest.Builder builder = this.factory.buildBsnVirtualPortCreateRequest();
        builder.setXid(16909060L).setVport((OFBsnVport)this.factory.buildBsnVportL2Gre().setFlags((Set)ImmutableSet.of((Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_LOCAL_MAC_IS_VALID, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_DSCP_ASSIGN, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_LOOPBACK_IS_VALID, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_RATE_LIMIT_IS_VALID)).setPortNo(OFPort.of((int)1)).setLoopbackPortNo(OFPort.of((int)2)).setLocalMac(MacAddress.of((String)"0a:0b:0c:0d:0e:0f")).setNhMac(MacAddress.of((String)"01:02:03:04:05:06")).setSrcIp(IPv4Address.of((String)"192.0.0.2")).setDstIp(IPv4Address.of((String)"192.0.16.2")).setDscp((short)1).setTtl((short)64).setVpn(48879L).setRateLimit(1024L).setIfName("foo").build());
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequest = builder.build();
        ByteBuf bb = Unpooled.buffer();
        bsnVirtualPortCreateRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnVirtualPortCreateRequest.Builder builder = this.factory.buildBsnVirtualPortCreateRequest();
        builder.setXid(16909060L).setVport((OFBsnVport)this.factory.buildBsnVportL2Gre().setFlags((Set)ImmutableSet.of((Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_LOCAL_MAC_IS_VALID, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_DSCP_ASSIGN, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_LOOPBACK_IS_VALID, (Object)OFBsnVportL2GreFlags.BSN_VPORT_L2GRE_RATE_LIMIT_IS_VALID)).setPortNo(OFPort.of((int)1)).setLoopbackPortNo(OFPort.of((int)2)).setLocalMac(MacAddress.of((String)"0a:0b:0c:0d:0e:0f")).setNhMac(MacAddress.of((String)"01:02:03:04:05:06")).setSrcIp(IPv4Address.of((String)"192.0.0.2")).setDstIp(IPv4Address.of((String)"192.0.16.2")).setDscp((short)1).setTtl((short)64).setVpn(48879L).setRateLimit(1024L).setIfName("foo").build());
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequestBuilt = builder.build();
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED);
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequestRead = OFBsnVirtualPortCreateRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnVirtualPortCreateRequestBuilt, (Object)bsnVirtualPortCreateRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ByteBuf input = Unpooled.copiedBuffer((byte[])BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED);
        OFBsnVirtualPortCreateRequest bsnVirtualPortCreateRequest = OFBsnVirtualPortCreateRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ByteBuf bb = Unpooled.buffer();
        bsnVirtualPortCreateRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_VIRTUAL_PORT_CREATE_REQUEST_SERIALIZED));
    }
}

